/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.semanticfunctions;

import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.contextvariables.ContextVariableType;
import com.microsoft.semantickernel.implementation.Todo;
import com.microsoft.semantickernel.orchestration.FunctionInvocation;
import com.microsoft.semantickernel.orchestration.FunctionResult;
import com.microsoft.semantickernel.orchestration.InvocationContext;
import com.microsoft.semantickernel.orchestration.PromptExecutionSettings;
import com.microsoft.semantickernel.semanticfunctions.InputVariable;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionArguments;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionFromMethod;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionFromPrompt;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionMetadata;
import com.microsoft.semantickernel.semanticfunctions.OutputVariable;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplate;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateConfig;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateFactory;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;

public abstract class KernelFunction<T> {
    private final KernelFunctionMetadata<?> metadata;
    @Nullable
    private final Map<String, PromptExecutionSettings> executionSettings;

    protected KernelFunction(KernelFunctionMetadata<?> metadata, @Nullable Map<String, PromptExecutionSettings> executionSettings) {
        this.metadata = metadata;
        this.executionSettings = new HashMap<String, PromptExecutionSettings>();
        if (executionSettings != null) {
            this.executionSettings.putAll(executionSettings);
        }
    }

    public static <T> KernelFunctionFromMethod.Builder<T> createFromMethod(Method method, Object target) {
        return KernelFunctionFromMethod.builder().withMethod(method).withTarget(target);
    }

    public static <T> FromPromptBuilder<T> createFromPrompt(String prompt) {
        return KernelFunctionFromPrompt.builder().withTemplate(prompt);
    }

    public static <T> FromPromptBuilder<T> createFromPrompt(PromptTemplateConfig promptTemplateConfiguration) {
        return KernelFunctionFromPrompt.builder().withPromptTemplateConfig(promptTemplateConfiguration);
    }

    @Nullable
    public String getPluginName() {
        return this.metadata.getPluginName();
    }

    public String getName() {
        return this.metadata.getName();
    }

    @Nullable
    public String getDescription() {
        return this.metadata.getDescription();
    }

    public String toEmbeddingString() {
        throw new Todo();
    }

    public String toManualString(boolean includeOutputs) {
        throw new Todo();
    }

    public Map<String, PromptExecutionSettings> getExecutionSettings() {
        return Collections.unmodifiableMap(this.executionSettings);
    }

    public KernelFunctionMetadata<?> getMetadata() {
        return this.metadata;
    }

    public abstract Mono<FunctionResult<T>> invokeAsync(Kernel var1, @Nullable KernelFunctionArguments var2, @Nullable ContextVariableType<T> var3, @Nullable InvocationContext var4);

    public FunctionResult<T> invoke(Kernel kernel, @Nullable KernelFunctionArguments arguments, @Nullable ContextVariableType<T> variableType, @Nullable InvocationContext invocationContext) {
        return (FunctionResult)this.invokeAsync(kernel, arguments, variableType, invocationContext).block();
    }

    public FunctionInvocation<T> invokeAsync(Kernel kernel) {
        return new FunctionInvocation(kernel, this);
    }

    public FunctionResult<T> invoke(Kernel kernel) {
        return (FunctionResult)this.invokeAsync(kernel).block();
    }

    public static interface FromPromptBuilder<T> {
        public FromPromptBuilder<T> withName(@Nullable String var1);

        public FromPromptBuilder<T> withInputParameters(@Nullable List<InputVariable> var1);

        public FromPromptBuilder<T> withPromptTemplate(@Nullable PromptTemplate var1);

        public FromPromptBuilder<T> withExecutionSettings(@Nullable Map<String, PromptExecutionSettings> var1);

        public FromPromptBuilder<T> withDefaultExecutionSettings(@Nullable PromptExecutionSettings var1);

        public FromPromptBuilder<T> withDescription(@Nullable String var1);

        public FromPromptBuilder<T> withTemplate(@Nullable String var1);

        public KernelFunction<T> build();

        public FromPromptBuilder<T> withTemplateFormat(String var1);

        public <U> FromPromptBuilder<U> withOutputVariable(@Nullable OutputVariable<U> var1);

        public FromPromptBuilder<T> withOutputVariable(@Nullable String var1, String var2);

        public FromPromptBuilder<T> withPromptTemplateFactory(@Nullable PromptTemplateFactory var1);

        public FromPromptBuilder<T> withPromptTemplateConfig(@Nullable PromptTemplateConfig var1);
    }
}

