/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.implementation;

import com.microsoft.semantickernel.localization.SemanticKernelResources;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLoadUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLoadUtil.class);

    private ServiceLoadUtil() {
    }

    public static <T> Supplier<T> findServiceLoader(Class<T> clazz, String alternativeClassName) {
        List<T> services = ServiceLoadUtil.findAllServiceLoaders(clazz);
        Object impl = null;
        if (!services.isEmpty()) {
            impl = services.get(0);
        }
        if (impl == null) {
            try {
                Object instance = Class.forName(alternativeClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (clazz.isInstance(instance)) {
                    impl = instance;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
                LOGGER.error(String.format(SemanticKernelResources.getString("unable.to.load.service.s"), clazz.getName()), (Throwable)e);
            }
            if (impl == null) {
                throw new RuntimeException(String.format("Service not found: %s", clazz.getName()));
            }
        }
        try {
            Constructor<?> constructor = impl.getClass().getConstructor(new Class[0]);
            if (!clazz.isInstance(constructor.newInstance(new Object[0]))) {
                throw new RuntimeException("Builder creates instance of the wrong type: " + clazz.getName());
            }
            return () -> {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Builder requires a no args constructor: " + clazz.getName());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Builder is of wrong type: " + clazz.getName());
        }
    }

    static <T> List<T> findAllServiceLoaders(Class<T> clazz) {
        ArrayList serviceLoaders = new ArrayList();
        ServiceLoader<T> factory = ServiceLoader.load(clazz);
        Iterator<T> iterator = factory.iterator();
        iterator.forEachRemaining(serviceLoaders::add);
        return serviceLoaders;
    }
}

