/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.exceptions;

import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.localization.SemanticKernelResources;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AIException
extends SKException {
    @Nonnull
    private final ErrorCodes errorCode;

    public AIException(@Nonnull ErrorCodes error) {
        this(error, null, null);
    }

    public AIException(@Nonnull ErrorCodes errorCode, @Nullable String message) {
        this(errorCode, message, null);
    }

    public AIException(@Nonnull ErrorCodes errorCode, @Nullable String message, @Nullable Throwable innerException) {
        super(AIException.formatDefaultMessage(errorCode.getMessage(), message), innerException);
        this.errorCode = errorCode;
    }

    public ErrorCodes getErrorCode() {
        return this.errorCode;
    }

    public static enum ErrorCodes {
        UNKNOWN_ERROR(SemanticKernelResources.getString("unknown.error")),
        NO_RESPONSE(SemanticKernelResources.getString("no.response")),
        ACCESS_DENIED(SemanticKernelResources.getString("access.is.denied")),
        INVALID_REQUEST(SemanticKernelResources.getString("the.request.was.invalid")),
        INVALID_RESPONSE_CONTENT(SemanticKernelResources.getString("the.content.of.the.response.was.invalid")),
        THROTTLING(SemanticKernelResources.getString("the.request.was.throttled")),
        REQUEST_TIMEOUT(SemanticKernelResources.getString("the.request.timed.out")),
        SERVICE_ERROR(SemanticKernelResources.getString("there.was.an.error.in.the.service")),
        MODEL_NOT_AVAILABLE(SemanticKernelResources.getString("the.requested.model.is.not.available")),
        INVALID_CONFIGURATION(SemanticKernelResources.getString("the.supplied.configuration.was.invalid")),
        FUNCTION_TYPE_NOT_SUPPORTED(SemanticKernelResources.getString("the.function.is.not.supported"));

        private final String message;

        private ErrorCodes(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

