/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.data.vectorstorage;

import com.microsoft.semantickernel.data.vectorstorage.options.GetRecordOptions;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

public class VectorStoreRecordMapper<Record, StorageModel> {
    @Nullable
    private final Function<Record, StorageModel> recordToStorageModelMapper;
    private final BiFunction<StorageModel, GetRecordOptions, Record> storageModelToRecordMapper;

    protected VectorStoreRecordMapper(@Nullable Function<Record, StorageModel> recordToStorageModelMapper, BiFunction<StorageModel, GetRecordOptions, Record> storageModelToRecordMapper) {
        this.recordToStorageModelMapper = recordToStorageModelMapper;
        this.storageModelToRecordMapper = storageModelToRecordMapper;
    }

    @Nullable
    public Function<Record, StorageModel> getRecordToStorageModelMapper() {
        return this.recordToStorageModelMapper;
    }

    public BiFunction<StorageModel, GetRecordOptions, Record> getStorageModelToRecordMapper() {
        return this.storageModelToRecordMapper;
    }

    public StorageModel mapRecordToStorageModel(Record record) {
        return this.getRecordToStorageModelMapper().apply(record);
    }

    public Record mapStorageModelToRecord(StorageModel storageModel, GetRecordOptions options) {
        return this.getStorageModelToRecordMapper().apply(storageModel, options);
    }
}

