/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.data.textsearch;

import com.microsoft.semantickernel.data.textsearch.TextSearchResultLink;
import com.microsoft.semantickernel.data.textsearch.TextSearchResultName;
import com.microsoft.semantickernel.data.textsearch.TextSearchResultValue;
import com.microsoft.semantickernel.exceptions.SKException;
import java.lang.reflect.Field;

public class TextSearchResult {
    private final String name;
    private final String value;
    private final String link;

    TextSearchResult(String name, String value, String link) {
        this.name = name;
        this.value = value;
        this.link = link;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getLink() {
        return this.link;
    }

    public static TextSearchResult fromRecord(Object record) {
        String name = null;
        String value = null;
        String link = null;
        try {
            for (Field field : record.getClass().getDeclaredFields()) {
                if (field.isAnnotationPresent(TextSearchResultName.class)) {
                    if (name != null) {
                        throw new SKException("Multiple fields with @TextSearchResultName found");
                    }
                    field.setAccessible(true);
                    name = (String)field.get(record);
                }
                if (field.isAnnotationPresent(TextSearchResultValue.class)) {
                    if (value != null) {
                        throw new SKException("Multiple fields with @TextSearchResultValue found");
                    }
                    field.setAccessible(true);
                    value = (String)field.get(record);
                }
                if (!field.isAnnotationPresent(TextSearchResultLink.class)) continue;
                if (link != null) {
                    throw new SKException("Multiple fields with @TextSearchResultLink found");
                }
                field.setAccessible(true);
                link = (String)field.get(record);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (value == null) {
            throw new SKException("No field with @TextSearchResultValue found");
        }
        return new TextSearchResult(name, value, link);
    }
}

