/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.data;

import com.microsoft.semantickernel.data.VolatileVectorStoreRecordCollection;
import com.microsoft.semantickernel.data.VolatileVectorStoreRecordCollectionOptions;
import com.microsoft.semantickernel.data.vectorstorage.VectorStore;
import com.microsoft.semantickernel.data.vectorstorage.VectorStoreRecordCollection;
import com.microsoft.semantickernel.data.vectorstorage.VectorStoreRecordCollectionOptions;
import com.microsoft.semantickernel.exceptions.SKException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import reactor.core.publisher.Mono;

public class VolatileVectorStore
implements VectorStore {
    private final Map<String, Map<String, ?>> collections = new ConcurrentHashMap();

    @Override
    public <Key, Record> VectorStoreRecordCollection<Key, Record> getCollection(@Nonnull String collectionName, @Nonnull VectorStoreRecordCollectionOptions<Key, Record> options) {
        if (options.getKeyClass() != String.class) {
            throw new SKException("Volatile only supports string keys");
        }
        if (options.getRecordClass() == null) {
            throw new SKException("Record class is required");
        }
        return new VolatileVectorStoreRecordCollection(collectionName, this.collections, (VolatileVectorStoreRecordCollectionOptions)options);
    }

    @Override
    public Mono<List<String>> getCollectionNamesAsync() {
        return Mono.just(new ArrayList<String>(this.collections.keySet()));
    }
}

