/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.contextvariables;

import com.azure.ai.openai.models.CompletionsUsage;
import com.microsoft.semantickernel.contextvariables.ContextVariableType;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypeConverter;
import com.microsoft.semantickernel.contextvariables.ContextVariableTypes;
import com.microsoft.semantickernel.exceptions.SKException;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;

public class ContextVariable<T> {
    private final ContextVariableType<T> type;
    @Nullable
    private final T value;

    public ContextVariable(ContextVariableType<T> type, @Nullable T value) {
        this.type = type;
        this.value = value;
    }

    public static <T, U> ContextVariable<T> convert(@Nullable U it, ContextVariableType<T> requestedResultType) {
        return ContextVariable.convert(it, requestedResultType.getClazz(), new ContextVariableTypes(Collections.singletonList(requestedResultType.getConverter())));
    }

    public static <T, U> ContextVariable<T> convert(@Nullable U it, Class<T> requestedResultType, @Nullable ContextVariableTypes contextVariableTypes) {
        ContextVariableType<T> requestedResultTypeVariable;
        if (contextVariableTypes == null) {
            contextVariableTypes = new ContextVariableTypes();
        }
        if (it instanceof ContextVariable) {
            it = ((ContextVariable)it).getValue();
        }
        if (it == null) {
            return new ContextVariable<Object>(contextVariableTypes.getVariableTypeForClass(requestedResultType), null);
        }
        if (requestedResultType.isAssignableFrom(it.getClass())) {
            try {
                return contextVariableTypes.getVariableTypeForClass(requestedResultType).of(requestedResultType.cast(it));
            }
            catch (Exception e) {
                return new ContextVariable<T>(new ContextVariableType<T>(new ContextVariableTypeConverter.NoopConverter<T>(requestedResultType), requestedResultType), requestedResultType.cast(it));
            }
        }
        try {
            requestedResultTypeVariable = contextVariableTypes.getVariableTypeForClass(requestedResultType);
        }
        catch (Exception e) {
            throw new SKException("Unable to find variable type for " + requestedResultType, e);
        }
        ContextVariableType<?> typeOfActualReturnedType = null;
        try {
            typeOfActualReturnedType = contextVariableTypes.getVariableTypeForClass(it.getClass());
        }
        catch (Exception e) {
            try {
                typeOfActualReturnedType = contextVariableTypes.getVariableTypeForSuperClass(it.getClass());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (typeOfActualReturnedType != null) {
            T converted = typeOfActualReturnedType.getConverter().toObject(contextVariableTypes, it, requestedResultType, false);
            if (converted != null) {
                return contextVariableTypes.getVariableTypeForClass(requestedResultType).of(converted);
            }
            if (requestedResultType.isAssignableFrom(String.class)) {
                String str = typeOfActualReturnedType.getConverter().toPromptString(contextVariableTypes, typeOfActualReturnedType.getClazz().cast(it));
                return requestedResultTypeVariable.of(str);
            }
        }
        if (requestedResultTypeVariable != null) {
            T result = requestedResultTypeVariable.getConverter().fromObject(it);
            if (result != null) {
                return requestedResultTypeVariable.of(result);
            }
            if (it.getClass().equals(String.class)) {
                return requestedResultTypeVariable.of(requestedResultTypeVariable.getConverter().fromPromptString((String)it));
            }
        }
        throw new SKException("Unable to convert " + it.getClass() + " to " + requestedResultType);
    }

    public static ContextVariable<?> untypedOf(@Nullable Object value, Class<?> clazz, ContextVariableTypes types) {
        ContextVariableType<?> type = types.getVariableTypeForClass(clazz);
        return new ContextVariable<Object>(type, value);
    }

    public static ContextVariable<CompletionsUsage> of(CompletionsUsage x) {
        return ContextVariable.ofValue(x);
    }

    public static ContextVariable<OffsetDateTime> of(OffsetDateTime x) {
        return ContextVariable.ofValue(x);
    }

    public static ContextVariable<String> of(String value) {
        return ContextVariable.ofValue(value);
    }

    public static ContextVariable<Object> ofGlobalType(Object x) {
        return ContextVariable.ofValue(x);
    }

    private static <T> ContextVariable<T> ofValue(T value) {
        Objects.requireNonNull(value, "value cannot be null");
        if (value instanceof ContextVariable) {
            return (ContextVariable)value;
        }
        ContextVariableType<?> type = ContextVariableTypes.getGlobalVariableTypeForClass(value.getClass());
        return new ContextVariable(type, value);
    }

    public static <T> ContextVariable<T> of(T value, ContextVariableTypeConverter<T> converter) {
        Objects.requireNonNull(value, "value cannot be null");
        Objects.requireNonNull(converter, "converter cannot be null");
        ContextVariableType<T> type = new ContextVariableType<T>(converter, converter.getType());
        return new ContextVariable<T>(type, value);
    }

    @Nullable
    public T getValue() {
        return this.value;
    }

    @Nullable
    public <U> U getValue(Class<U> clazz) {
        try {
            return clazz.cast(this.value);
        }
        catch (ClassCastException e) {
            throw new SKException("Cannot cast " + (this.value != null ? this.value.getClass() : "null") + " to " + clazz, e);
        }
    }

    public ContextVariableType<T> getType() {
        return this.type;
    }

    public String toPromptString(@Nullable ContextVariableTypes types, ContextVariableTypeConverter<T> converter) {
        return converter.toPromptString(types, this.value);
    }

    public String toPromptString(ContextVariableTypes types) {
        return this.toPromptString(types, this.type.getConverter());
    }

    public String toPromptString() {
        return this.toPromptString(null, this.type.getConverter());
    }

    public boolean isEmpty() {
        return this.value == null || this.value.toString().isEmpty();
    }
}

