/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel;

import com.microsoft.semantickernel.contextvariables.CaseInsensitiveMap;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.localization.SemanticKernelResources;
import com.microsoft.semantickernel.plugin.KernelPlugin;
import com.microsoft.semantickernel.semanticfunctions.KernelFunction;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionMetadata;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KernelPluginCollection {
    private static final Logger LOGGER = LoggerFactory.getLogger(KernelPluginCollection.class);
    private final Map<String, KernelPlugin> plugins = new CaseInsensitiveMap<KernelPlugin>();

    KernelPluginCollection() {
    }

    KernelPluginCollection(List<KernelPlugin> plugins) {
        plugins.forEach(plugin -> this.putOrMerge(plugin.getName(), (KernelPlugin)plugin));
    }

    private void putOrMerge(String pluginName, KernelPlugin plugin) {
        if (this.plugins.containsKey(pluginName)) {
            plugin.getFunctions().entrySet().forEach(entry -> this.plugins.get(pluginName).addFunction((KernelFunction)entry.getValue()));
        } else {
            this.plugins.put(pluginName, plugin);
        }
    }

    KernelFunction<?> getFunction(String pluginName, String functionName) {
        KernelPlugin plugin = this.plugins.get(pluginName);
        if (plugin == null) {
            throw new SKException("Failed to find plugin " + pluginName);
        }
        KernelFunction function = plugin.get(functionName);
        if (function == null) {
            throw new SKException("Function '" + functionName + "' not found in plugin '" + pluginName + "'");
        }
        return function;
    }

    List<KernelFunction<?>> getFunctions() {
        return this.plugins.values().stream().flatMap(plugin -> plugin.getFunctions().values().stream()).collect(Collectors.toList());
    }

    List<KernelFunctionMetadata<?>> getFunctionsMetadata() {
        return this.plugins.values().stream().flatMap(plugin -> plugin.getFunctions().values().stream()).map(KernelFunction::getMetadata).collect(Collectors.toList());
    }

    Collection<KernelPlugin> getPlugins() {
        return Collections.unmodifiableCollection(this.plugins.values());
    }

    @Nullable
    KernelPlugin getPlugin(String pluginName) {
        return this.plugins.get(pluginName);
    }

    void add(KernelPlugin plugin) {
        if (this.plugins.containsKey(plugin.getName())) {
            LOGGER.warn(SemanticKernelResources.getString("plugin.already.exists.overwriting.existing.plugin"), (Object)plugin.getName());
        }
        this.plugins.put(plugin.getName(), plugin);
    }
}

