/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.services.audio;

import com.microsoft.semantickernel.exceptions.SKException;
import edu.umd.cs.findbugs.annotations.Nullable;

public class TextToAudioExecutionSettings {
    private final String voice;
    private final String responseFormat;
    @Nullable
    private final Double speed;

    public TextToAudioExecutionSettings(String voice, String responseFormat, @Nullable Double speed) {
        this.voice = voice;
        this.responseFormat = responseFormat;
        this.speed = speed;
    }

    public String getVoice() {
        return this.voice;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    @Nullable
    public Double getSpeed() {
        return this.speed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private String voice = null;
        @Nullable
        private String responseFormat = null;
        @Nullable
        private Double speed = null;

        public Builder withVoice(String voice) {
            this.voice = voice;
            return this;
        }

        public Builder withResponseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public Builder withSpeed(Double speed) {
            this.speed = speed;
            return this;
        }

        public TextToAudioExecutionSettings build() {
            if (this.voice == null) {
                throw new SKException("Voice must be set");
            }
            if (this.responseFormat == null) {
                throw new SKException("Response format must be set");
            }
            return new TextToAudioExecutionSettings(this.voice, this.responseFormat, this.speed);
        }
    }
}

