/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2;

import com.microsoft.rest.v2.MissingRequiredAnnotationException;
import com.microsoft.rest.v2.SwaggerMethodParser;
import com.microsoft.rest.v2.annotations.Host;
import com.microsoft.rest.v2.protocol.SerializerAdapter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class SwaggerInterfaceParser {
    private final Class<?> swaggerInterface;
    private final SerializerAdapter<?> serializer;
    private final String host;
    private final Map<Method, SwaggerMethodParser> methodParsers = new HashMap<Method, SwaggerMethodParser>();

    public SwaggerInterfaceParser(Class<?> swaggerInterface, SerializerAdapter<?> serializer) {
        this(swaggerInterface, serializer, null);
    }

    public SwaggerInterfaceParser(Class<?> swaggerInterface, SerializerAdapter<?> serializer, String host) {
        this.swaggerInterface = swaggerInterface;
        this.serializer = serializer;
        if (host != null && !host.isEmpty()) {
            this.host = host;
        } else {
            Host hostAnnotation = swaggerInterface.getAnnotation(Host.class);
            if (hostAnnotation != null && !hostAnnotation.value().isEmpty()) {
                this.host = hostAnnotation.value();
            } else {
                throw new MissingRequiredAnnotationException(Host.class, swaggerInterface);
            }
        }
    }

    public SwaggerMethodParser methodParser(Method swaggerMethod) {
        SwaggerMethodParser result = this.methodParsers.get(swaggerMethod);
        if (result == null) {
            result = new SwaggerMethodParser(swaggerMethod, this.serializer, this.host());
            this.methodParsers.put(swaggerMethod, result);
        }
        return result;
    }

    String host() {
        return this.host;
    }
}

