/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2;

import com.microsoft.rest.v2.Base64Url;
import com.microsoft.rest.v2.EncodedParameter;
import com.microsoft.rest.v2.InvalidReturnTypeException;
import com.microsoft.rest.v2.OperationDescription;
import com.microsoft.rest.v2.RestException;
import com.microsoft.rest.v2.RestResponse;
import com.microsoft.rest.v2.ServiceClient;
import com.microsoft.rest.v2.SwaggerInterfaceParser;
import com.microsoft.rest.v2.SwaggerMethodParser;
import com.microsoft.rest.v2.annotations.ResumeOperation;
import com.microsoft.rest.v2.credentials.ServiceClientCredentials;
import com.microsoft.rest.v2.http.HttpHeader;
import com.microsoft.rest.v2.http.HttpHeaders;
import com.microsoft.rest.v2.http.HttpMethod;
import com.microsoft.rest.v2.http.HttpPipeline;
import com.microsoft.rest.v2.http.HttpPipelineBuilder;
import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.http.UrlBuilder;
import com.microsoft.rest.v2.policy.CookiePolicyFactory;
import com.microsoft.rest.v2.policy.CredentialsPolicyFactory;
import com.microsoft.rest.v2.policy.DecodingPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RetryPolicyFactory;
import com.microsoft.rest.v2.policy.UserAgentPolicyFactory;
import com.microsoft.rest.v2.protocol.HttpResponseDecoder;
import com.microsoft.rest.v2.protocol.SerializerAdapter;
import com.microsoft.rest.v2.protocol.SerializerEncoding;
import com.microsoft.rest.v2.serializer.JacksonAdapter;
import com.microsoft.rest.v2.util.FlowableUtil;
import com.microsoft.rest.v2.util.TypeUtil;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Map;

public class RestProxy
implements InvocationHandler {
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter<?> serializer;
    private final SwaggerInterfaceParser interfaceParser;

    public RestProxy(HttpPipeline httpPipeline, SerializerAdapter<?> serializer, SwaggerInterfaceParser interfaceParser) {
        this.httpPipeline = httpPipeline;
        this.serializer = serializer;
        this.interfaceParser = interfaceParser;
    }

    private SwaggerMethodParser methodParser(Method method) {
        return this.interfaceParser.methodParser(method);
    }

    public SerializerAdapter<?> serializer() {
        return this.serializer;
    }

    public Single<HttpResponse> sendHttpRequestAsync(HttpRequest request) {
        return this.httpPipeline.sendRequestAsync(request);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        try {
            SwaggerMethodParser methodParser = null;
            HttpRequest request = null;
            if (method.isAnnotationPresent(ResumeOperation.class)) {
                Method[] methods;
                OperationDescription opDesc = (OperationDescription)args[0];
                Method resumeMethod = null;
                for (Method origMethod : methods = method.getDeclaringClass().getMethods()) {
                    if (!origMethod.getName().equals(opDesc.methodName())) continue;
                    resumeMethod = origMethod;
                    break;
                }
                methodParser = this.methodParser(resumeMethod);
                request = this.createHttpRequest(opDesc, methodParser, args);
                Type returnType = methodParser.returnType();
                return this.handleResumeOperation(request, opDesc, methodParser, returnType);
            }
            methodParser = this.methodParser(method);
            request = this.createHttpRequest(methodParser, args);
            Single<HttpResponse> asyncResponse = this.sendHttpRequestAsync(request);
            Type returnType = methodParser.returnType();
            return this.handleAsyncHttpResponse(request, asyncResponse, methodParser, returnType);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private HttpRequest createHttpRequest(SwaggerMethodParser methodParser, Object[] args) throws IOException {
        UrlBuilder urlBuilder;
        String path = methodParser.path(args);
        UrlBuilder pathUrlBuilder = UrlBuilder.parse(path);
        if (pathUrlBuilder.scheme() != null) {
            urlBuilder = pathUrlBuilder;
        } else {
            urlBuilder = new UrlBuilder();
            urlBuilder.withPath(path);
            String scheme = methodParser.scheme(args);
            urlBuilder.withScheme(scheme);
            String host = methodParser.host(args);
            urlBuilder.withHost(host);
        }
        for (EncodedParameter queryParameter : methodParser.encodedQueryParameters(args)) {
            urlBuilder.setQueryParameter(queryParameter.name(), queryParameter.encodedValue());
        }
        URL url = urlBuilder.toURL();
        HttpRequest request = new HttpRequest(methodParser.fullyQualifiedMethodName(), methodParser.httpMethod(), url, new HttpResponseDecoder(methodParser, this.serializer));
        request.withContext(methodParser.context(args));
        Object bodyContentObject = methodParser.body(args);
        if (bodyContentObject == null) {
            request.headers().set("Content-Length", "0");
        } else {
            String bodyContentString;
            String[] contentTypeParts;
            String contentType = methodParser.bodyContentType();
            if (contentType == null || contentType.isEmpty()) {
                contentType = bodyContentObject instanceof byte[] || bodyContentObject instanceof String ? "application/octet-stream" : "application/json";
            }
            request.headers().set("Content-Type", contentType);
            boolean isJson = false;
            for (String contentTypePart : contentTypeParts = contentType.split(";")) {
                if (!contentTypePart.trim().equalsIgnoreCase("application/json")) continue;
                isJson = true;
                break;
            }
            if (isJson) {
                bodyContentString = this.serializer.serialize(bodyContentObject, SerializerEncoding.JSON);
                request.withBody(bodyContentString);
            } else if (FlowableUtil.isFlowableByteBuffer(methodParser.bodyJavaType())) {
                request.withBody((Flowable<ByteBuffer>)((Flowable)bodyContentObject));
            } else if (bodyContentObject instanceof byte[]) {
                request.withBody((byte[])bodyContentObject);
            } else if (bodyContentObject instanceof String) {
                bodyContentString = (String)bodyContentObject;
                if (!bodyContentString.isEmpty()) {
                    request.withBody(bodyContentString);
                }
            } else {
                bodyContentString = this.serializer.serialize(bodyContentObject, SerializerEncoding.fromHeaders(request.headers()));
                request.withBody(bodyContentString);
            }
        }
        for (HttpHeader header : methodParser.headers(args)) {
            request.withHeader(header.name(), header.value());
        }
        return request;
    }

    private HttpRequest createHttpRequest(OperationDescription operationDescription, SwaggerMethodParser methodParser, Object[] args) throws IOException {
        HttpRequest request = new HttpRequest(methodParser.fullyQualifiedMethodName(), methodParser.httpMethod(), operationDescription.url(), new HttpResponseDecoder(methodParser, this.serializer));
        Object bodyContentObject = methodParser.body(args);
        if (bodyContentObject == null) {
            request.headers().set("Content-Length", "0");
        } else {
            String bodyContentString;
            String[] contentTypeParts;
            String contentType = methodParser.bodyContentType();
            if (contentType == null || contentType.isEmpty()) {
                contentType = bodyContentObject instanceof byte[] || bodyContentObject instanceof String ? "application/octet-stream" : "application/json";
            }
            request.headers().set("Content-Type", contentType);
            boolean isJson = false;
            for (String contentTypePart : contentTypeParts = contentType.split(";")) {
                if (!contentTypePart.trim().equalsIgnoreCase("application/json")) continue;
                isJson = true;
                break;
            }
            if (isJson) {
                bodyContentString = this.serializer.serialize(bodyContentObject, SerializerEncoding.JSON);
                request.withBody(bodyContentString);
            } else if (FlowableUtil.isFlowableByteBuffer(methodParser.bodyJavaType())) {
                request.withBody((Flowable<ByteBuffer>)((Flowable)bodyContentObject));
            } else if (bodyContentObject instanceof byte[]) {
                request.withBody((byte[])bodyContentObject);
            } else if (bodyContentObject instanceof String) {
                bodyContentString = (String)bodyContentObject;
                if (!bodyContentString.isEmpty()) {
                    request.withBody(bodyContentString);
                }
            } else {
                bodyContentString = this.serializer.serialize(bodyContentObject, SerializerEncoding.fromHeaders(request.headers()));
                request.withBody(bodyContentString);
            }
        }
        for (String headerName : operationDescription.headers().keySet()) {
            request.withHeader(headerName, operationDescription.headers().get(headerName));
        }
        return request;
    }

    private Exception instantiateUnexpectedException(SwaggerMethodParser methodParser, HttpResponse response, String responseContent) {
        Exception result;
        int responseStatusCode = response.statusCode();
        Class<? extends RestException> exceptionType = methodParser.exceptionType();
        Class<?> exceptionBodyType = methodParser.exceptionBodyType();
        String contentType = response.headerValue("Content-Type");
        String bodyRepresentation = "application/octet-stream".equalsIgnoreCase(contentType) ? "(" + response.headerValue("Content-Length") + "-byte body)" : (responseContent.isEmpty() ? "(empty body)" : "\"" + responseContent + "\"");
        try {
            Constructor<? extends RestException> exceptionConstructor = exceptionType.getConstructor(String.class, HttpResponse.class, exceptionBodyType);
            result = exceptionConstructor.newInstance("Status code " + responseStatusCode + ", " + bodyRepresentation, response, response.deserializedBody());
        }
        catch (ReflectiveOperationException e) {
            String message = "Status code " + responseStatusCode + ", but an instance of " + exceptionType.getCanonicalName() + " cannot be created. Response body: " + bodyRepresentation;
            result = new IOException(message, e);
        }
        return result;
    }

    private Single<HttpResponse> ensureExpectedStatus(Single<HttpResponse> asyncResponse, final SwaggerMethodParser methodParser) {
        return asyncResponse.flatMap((Function)new Function<HttpResponse, Single<? extends HttpResponse>>(){

            public Single<? extends HttpResponse> apply(HttpResponse httpResponse) {
                return RestProxy.this.ensureExpectedStatus(httpResponse, methodParser);
            }
        });
    }

    private Single<HttpResponse> ensureExpectedStatus(HttpResponse response, SwaggerMethodParser methodParser) {
        return this.ensureExpectedStatus(response, methodParser, null);
    }

    public Single<HttpResponse> ensureExpectedStatus(final HttpResponse response, final SwaggerMethodParser methodParser, int[] additionalAllowedStatusCodes) {
        int responseStatusCode = response.statusCode();
        Single asyncResult = !methodParser.isExpectedResponseStatusCode(responseStatusCode, additionalAllowedStatusCodes) ? response.bodyAsString().flatMap((Function)new Function<String, Single<HttpResponse>>(){

            public Single<HttpResponse> apply(String responseBody) throws Exception {
                return Single.error((Throwable)RestProxy.this.instantiateUnexpectedException(methodParser, response, responseBody));
            }
        }) : Single.just((Object)response);
        return asyncResult;
    }

    public Constructor<? extends RestResponse<?, ?>> getRestResponseConstructor(Type entityType) {
        Class<?> rawEntityType = TypeUtil.getRawClass(entityType);
        try {
            Constructor<?> ctor = null;
            for (Constructor<?> c : rawEntityType.getDeclaredConstructors()) {
                if (c.getParameterTypes().length != 5 || !c.getParameterTypes()[0].equals(HttpRequest.class) || !c.getParameterTypes()[1].equals(Integer.TYPE) || !c.getParameterTypes()[3].equals(Map.class)) continue;
                ctor = c;
            }
            if (ctor == null) {
                throw new NoSuchMethodException("No appropriate constructor found for type " + rawEntityType.getName());
            }
            return ctor;
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
    }

    private Single<?> handleRestResponseReturnTypeAsync(HttpResponse response, SwaggerMethodParser methodParser, Type entityType) {
        int responseStatusCode = response.statusCode();
        try {
            Single asyncResult;
            if (TypeUtil.isTypeOrSubTypeOf(entityType, RestResponse.class)) {
                Constructor<RestResponse<?, ?>> responseConstructor = this.getRestResponseConstructor(entityType);
                Type[] deserializedTypes = TypeUtil.getTypeArguments(TypeUtil.getSuperType(entityType, RestResponse.class));
                HttpHeaders responseHeaders = response.headers();
                Object deserializedHeaders = response.deserializedHeaders();
                Type bodyType = deserializedTypes[1];
                if (TypeUtil.isTypeOrSubTypeOf(bodyType, Void.class)) {
                    asyncResult = response.body().lastElement().ignoreElement().andThen((SingleSource)Single.just(responseConstructor.newInstance(response.request(), responseStatusCode, deserializedHeaders, responseHeaders.toMap(), null)));
                } else {
                    Map<String, String> rawHeaders = responseHeaders.toMap();
                    asyncResult = this.handleBodyReturnTypeAsync(response, methodParser, bodyType).map(body -> (RestResponse)responseConstructor.newInstance(response.request(), responseStatusCode, deserializedHeaders, rawHeaders, body)).toSingle(responseConstructor.newInstance(response.request(), responseStatusCode, deserializedHeaders, rawHeaders, null));
                }
                Type headersType = deserializedTypes[0];
                if (!response.isDecoded() && !TypeUtil.isTypeOrSubTypeOf(headersType, Void.class)) {
                    asyncResult = asyncResult.toCompletable().andThen((SingleSource)Single.error((Throwable)new RestException("No deserialized headers were found. Please add a DecodingPolicyFactory to the HttpPipeline.", response, (Object)null)));
                }
            } else {
                asyncResult = this.handleBodyReturnTypeAsync(response, methodParser, entityType).toSingle();
            }
            return asyncResult;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected final Maybe<?> handleBodyReturnTypeAsync(HttpResponse response, SwaggerMethodParser methodParser, Type entityType) {
        Maybe asyncResult;
        int responseStatusCode = response.statusCode();
        HttpMethod httpMethod = methodParser.httpMethod();
        Type returnValueWireType = methodParser.returnValueWireType();
        if (httpMethod == HttpMethod.HEAD && (TypeUtil.isTypeOrSubTypeOf(entityType, Boolean.TYPE) || TypeUtil.isTypeOrSubTypeOf(entityType, Boolean.class))) {
            boolean isSuccess = responseStatusCode / 100 == 2;
            asyncResult = Maybe.just((Object)isSuccess);
        } else if (TypeUtil.isTypeOrSubTypeOf(entityType, byte[].class)) {
            Maybe responseBodyBytesAsync = response.bodyAsByteArray().toMaybe();
            if (returnValueWireType == Base64Url.class) {
                responseBodyBytesAsync = responseBodyBytesAsync.map(base64UrlBytes -> new Base64Url((byte[])base64UrlBytes).decodedBytes());
            }
            asyncResult = responseBodyBytesAsync;
        } else {
            Object result;
            asyncResult = FlowableUtil.isFlowableByteBuffer(entityType) ? Maybe.just(response.body()) : (!response.isDecoded() ? Maybe.error((Throwable)new RestException("No deserialized response body was found. Please add a DecodingPolicyFactory to the HttpPipeline.", response, (Object)null)) : ((result = response.deserializedBody()) == null ? Maybe.empty() : Maybe.just((Object)result)));
        }
        return asyncResult;
    }

    protected Object handleAsyncHttpResponse(HttpRequest httpRequest, Single<HttpResponse> asyncHttpResponse, SwaggerMethodParser methodParser, Type returnType) {
        return this.handleRestReturnType(httpRequest, asyncHttpResponse, methodParser, returnType);
    }

    protected Object handleResumeOperation(HttpRequest httpRequest, OperationDescription operationDescription, SwaggerMethodParser methodParser, Type returnType) throws Exception {
        throw new Exception("The resume operation is not avaiable in the base RestProxy class.");
    }

    public final Object handleRestReturnType(HttpRequest httpRequest, Single<HttpResponse> asyncHttpResponse, SwaggerMethodParser methodParser, Type returnType) {
        Object result;
        Single<HttpResponse> asyncExpectedResponse = this.ensureExpectedStatus(asyncHttpResponse, methodParser);
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Completable.class)) {
            result = Completable.fromSingle(asyncExpectedResponse);
        } else if (TypeUtil.isTypeOrSubTypeOf(returnType, Single.class)) {
            Type singleTypeParam = TypeUtil.getTypeArgument(returnType);
            result = asyncExpectedResponse.flatMap(response -> this.handleRestResponseReturnTypeAsync((HttpResponse)response, methodParser, singleTypeParam));
        } else {
            if (TypeUtil.isTypeOrSubTypeOf(returnType, Observable.class)) {
                throw new InvalidReturnTypeException("RestProxy does not support swagger interface methods (such as " + methodParser.fullyQualifiedMethodName() + "()) with a return type of " + returnType.toString());
            }
            if (FlowableUtil.isFlowableByteBuffer(returnType)) {
                result = asyncExpectedResponse.flatMapPublisher(HttpResponse::body);
            } else if (TypeUtil.isTypeOrSubTypeOf(returnType, Void.TYPE) || TypeUtil.isTypeOrSubTypeOf(returnType, Void.class)) {
                asyncExpectedResponse.blockingGet();
                result = null;
            } else {
                result = asyncExpectedResponse.flatMap(httpResponse -> this.handleRestResponseReturnTypeAsync((HttpResponse)httpResponse, methodParser, returnType)).blockingGet();
            }
        }
        return result;
    }

    public static SerializerAdapter<?> createDefaultSerializer() {
        return new JacksonAdapter();
    }

    public static HttpPipeline createDefaultPipeline() {
        return RestProxy.createDefaultPipeline((RequestPolicyFactory)null);
    }

    public static HttpPipeline createDefaultPipeline(ServiceClientCredentials credentials) {
        return RestProxy.createDefaultPipeline(new CredentialsPolicyFactory(credentials));
    }

    public static HttpPipeline createDefaultPipeline(RequestPolicyFactory credentialsPolicy) {
        HttpPipelineBuilder builder = new HttpPipelineBuilder();
        builder.withRequestPolicy(new UserAgentPolicyFactory());
        builder.withRequestPolicy(new RetryPolicyFactory());
        builder.withRequestPolicy(new DecodingPolicyFactory());
        builder.withRequestPolicy(new CookiePolicyFactory());
        if (credentialsPolicy != null) {
            builder.withRequestPolicy(credentialsPolicy);
        }
        return builder.build();
    }

    public static <A> A create(Class<A> swaggerInterface) {
        return RestProxy.create(swaggerInterface, RestProxy.createDefaultPipeline(), RestProxy.createDefaultSerializer());
    }

    public static <A> A create(Class<A> swaggerInterface, HttpPipeline httpPipeline) {
        return RestProxy.create(swaggerInterface, httpPipeline, RestProxy.createDefaultSerializer());
    }

    public static <A> A create(Class<A> swaggerInterface, ServiceClient serviceClient) {
        return RestProxy.create(swaggerInterface, serviceClient.httpPipeline(), serviceClient.serializerAdapter());
    }

    public static <A> A create(Class<A> swaggerInterface, HttpPipeline httpPipeline, SerializerAdapter<?> serializer) {
        SwaggerInterfaceParser interfaceParser = new SwaggerInterfaceParser(swaggerInterface, serializer);
        RestProxy restProxy = new RestProxy(httpPipeline, serializer, interfaceParser);
        return (A)Proxy.newProxyInstance(swaggerInterface.getClassLoader(), new Class[]{swaggerInterface}, (InvocationHandler)restProxy);
    }
}

