// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WindowsPhone81GeneralConfiguration;
import com.microsoft.graph.models.DeviceConfigurationAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Phone81General Configuration Request.
 */
public class WindowsPhone81GeneralConfigurationRequest extends BaseRequest<WindowsPhone81GeneralConfiguration> {
	
    /**
     * The request for the WindowsPhone81GeneralConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WindowsPhone81GeneralConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsPhone81GeneralConfiguration.class);
    }

    /**
     * Gets the WindowsPhone81GeneralConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsPhone81GeneralConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WindowsPhone81GeneralConfiguration from the service
     *
     * @return the WindowsPhone81GeneralConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsPhone81GeneralConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsPhone81GeneralConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WindowsPhone81GeneralConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WindowsPhone81GeneralConfiguration with a source
     *
     * @param sourceWindowsPhone81GeneralConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsPhone81GeneralConfiguration> patchAsync(@Nonnull final WindowsPhone81GeneralConfiguration sourceWindowsPhone81GeneralConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceWindowsPhone81GeneralConfiguration);
    }

    /**
     * Patches this WindowsPhone81GeneralConfiguration with a source
     *
     * @param sourceWindowsPhone81GeneralConfiguration the source object with updates
     * @return the updated WindowsPhone81GeneralConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsPhone81GeneralConfiguration patch(@Nonnull final WindowsPhone81GeneralConfiguration sourceWindowsPhone81GeneralConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindowsPhone81GeneralConfiguration);
    }

    /**
     * Creates a WindowsPhone81GeneralConfiguration with a new object
     *
     * @param newWindowsPhone81GeneralConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsPhone81GeneralConfiguration> postAsync(@Nonnull final WindowsPhone81GeneralConfiguration newWindowsPhone81GeneralConfiguration) {
        return sendAsync(HttpMethod.POST, newWindowsPhone81GeneralConfiguration);
    }

    /**
     * Creates a WindowsPhone81GeneralConfiguration with a new object
     *
     * @param newWindowsPhone81GeneralConfiguration the new object to create
     * @return the created WindowsPhone81GeneralConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsPhone81GeneralConfiguration post(@Nonnull final WindowsPhone81GeneralConfiguration newWindowsPhone81GeneralConfiguration) throws ClientException {
        return send(HttpMethod.POST, newWindowsPhone81GeneralConfiguration);
    }

    /**
     * Creates a WindowsPhone81GeneralConfiguration with a new object
     *
     * @param newWindowsPhone81GeneralConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsPhone81GeneralConfiguration> putAsync(@Nonnull final WindowsPhone81GeneralConfiguration newWindowsPhone81GeneralConfiguration) {
        return sendAsync(HttpMethod.PUT, newWindowsPhone81GeneralConfiguration);
    }

    /**
     * Creates a WindowsPhone81GeneralConfiguration with a new object
     *
     * @param newWindowsPhone81GeneralConfiguration the object to create/update
     * @return the created WindowsPhone81GeneralConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsPhone81GeneralConfiguration put(@Nonnull final WindowsPhone81GeneralConfiguration newWindowsPhone81GeneralConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newWindowsPhone81GeneralConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WindowsPhone81GeneralConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WindowsPhone81GeneralConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

