// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.SubjectRightsRequestGetFinalAttachmentRequest;
import com.microsoft.graph.models.SubjectRightsRequest;

import com.microsoft.graph.http.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Subject Rights Request Get Final Attachment Request Builder.
 */
public class SubjectRightsRequestGetFinalAttachmentRequestBuilder extends BaseFunctionRequestBuilder<java.io.InputStream> {

    /**
     * The request builder for this SubjectRightsRequestGetFinalAttachment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SubjectRightsRequestGetFinalAttachmentRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the SubjectRightsRequestGetFinalAttachmentRequest
     *
     * @param requestOptions the options for the request
     * @return the SubjectRightsRequestGetFinalAttachmentRequest instance
     */
    @Nonnull
    public SubjectRightsRequestGetFinalAttachmentRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the SubjectRightsRequestGetFinalAttachmentRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the SubjectRightsRequestGetFinalAttachmentRequest instance
     */
    @Nonnull
    public SubjectRightsRequestGetFinalAttachmentRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final SubjectRightsRequestGetFinalAttachmentRequest request = new SubjectRightsRequestGetFinalAttachmentRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
