// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.ServiceUpdateMessageMarkUnreadRequest;
import com.microsoft.graph.models.ServiceUpdateMessage;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.ServiceUpdateMessageMarkUnreadParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Update Message Mark Unread Request Builder.
 */
public class ServiceUpdateMessageMarkUnreadRequestBuilder extends BaseActionRequestBuilder<Boolean> {

    /**
     * The request builder for this ServiceUpdateMessageMarkUnread
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ServiceUpdateMessageMarkUnreadRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private ServiceUpdateMessageMarkUnreadParameterSet body;
    /**
     * The request builder for this ServiceUpdateMessageMarkUnread
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public ServiceUpdateMessageMarkUnreadRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final ServiceUpdateMessageMarkUnreadParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the ServiceUpdateMessageMarkUnreadRequest
     *
     * @param requestOptions the options for the request
     * @return the ServiceUpdateMessageMarkUnreadRequest instance
     */
    @Nonnull
    public ServiceUpdateMessageMarkUnreadRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the ServiceUpdateMessageMarkUnreadRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the ServiceUpdateMessageMarkUnreadRequest instance
     */
    @Nonnull
    public ServiceUpdateMessageMarkUnreadRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final ServiceUpdateMessageMarkUnreadRequest request = new ServiceUpdateMessageMarkUnreadRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
