// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ServicePrincipal;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.ServicePrincipalDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.ServicePrincipalDeltaCollectionRequest;
import com.microsoft.graph.requests.ServicePrincipalDeltaCollectionResponse;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Principal Delta Collection Request Builder.
 */
public class ServicePrincipalDeltaCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<ServicePrincipal, ServicePrincipalDeltaCollectionRequestBuilder, ServicePrincipalDeltaCollectionResponse, ServicePrincipalDeltaCollectionPage, ServicePrincipalDeltaCollectionRequest> {

    /**
     * The request builder for this collection of ServicePrincipal
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ServicePrincipalDeltaCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ServicePrincipalDeltaCollectionRequestBuilder.class, ServicePrincipalDeltaCollectionRequest.class);
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the ServicePrincipalDeltaCollectionRequest instance
     */
    @Override
    @Nonnull
    public ServicePrincipalDeltaCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final ServicePrincipalDeltaCollectionRequest request = super.buildRequest(requestOptions);
        return request;
    }
}
