// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.RoleManagement;
import com.microsoft.graph.requests.RbacApplicationRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Role Management Request.
 */
public class RoleManagementRequest extends BaseRequest<RoleManagement> {
	
    /**
     * The request for the RoleManagement
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RoleManagementRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, RoleManagement.class);
    }

    /**
     * Gets the RoleManagement from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RoleManagement> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the RoleManagement from the service
     *
     * @return the RoleManagement from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RoleManagement get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RoleManagement> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public RoleManagement delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this RoleManagement with a source
     *
     * @param sourceRoleManagement the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RoleManagement> patchAsync(@Nonnull final RoleManagement sourceRoleManagement) {
        return sendAsync(HttpMethod.PATCH, sourceRoleManagement);
    }

    /**
     * Patches this RoleManagement with a source
     *
     * @param sourceRoleManagement the source object with updates
     * @return the updated RoleManagement
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RoleManagement patch(@Nonnull final RoleManagement sourceRoleManagement) throws ClientException {
        return send(HttpMethod.PATCH, sourceRoleManagement);
    }

    /**
     * Creates a RoleManagement with a new object
     *
     * @param newRoleManagement the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RoleManagement> postAsync(@Nonnull final RoleManagement newRoleManagement) {
        return sendAsync(HttpMethod.POST, newRoleManagement);
    }

    /**
     * Creates a RoleManagement with a new object
     *
     * @param newRoleManagement the new object to create
     * @return the created RoleManagement
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RoleManagement post(@Nonnull final RoleManagement newRoleManagement) throws ClientException {
        return send(HttpMethod.POST, newRoleManagement);
    }

    /**
     * Creates a RoleManagement with a new object
     *
     * @param newRoleManagement the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RoleManagement> putAsync(@Nonnull final RoleManagement newRoleManagement) {
        return sendAsync(HttpMethod.PUT, newRoleManagement);
    }

    /**
     * Creates a RoleManagement with a new object
     *
     * @param newRoleManagement the object to create/update
     * @return the created RoleManagement
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RoleManagement put(@Nonnull final RoleManagement newRoleManagement) throws ClientException {
        return send(HttpMethod.PUT, newRoleManagement);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public RoleManagementRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public RoleManagementRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

