// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ProvisioningObjectSummary;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Provisioning Object Summary Request.
 */
public class ProvisioningObjectSummaryRequest extends BaseRequest<ProvisioningObjectSummary> {
	
    /**
     * The request for the ProvisioningObjectSummary
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ProvisioningObjectSummaryRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ProvisioningObjectSummary.class);
    }

    /**
     * Gets the ProvisioningObjectSummary from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ProvisioningObjectSummary> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ProvisioningObjectSummary from the service
     *
     * @return the ProvisioningObjectSummary from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ProvisioningObjectSummary get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ProvisioningObjectSummary> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ProvisioningObjectSummary delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ProvisioningObjectSummary with a source
     *
     * @param sourceProvisioningObjectSummary the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ProvisioningObjectSummary> patchAsync(@Nonnull final ProvisioningObjectSummary sourceProvisioningObjectSummary) {
        return sendAsync(HttpMethod.PATCH, sourceProvisioningObjectSummary);
    }

    /**
     * Patches this ProvisioningObjectSummary with a source
     *
     * @param sourceProvisioningObjectSummary the source object with updates
     * @return the updated ProvisioningObjectSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ProvisioningObjectSummary patch(@Nonnull final ProvisioningObjectSummary sourceProvisioningObjectSummary) throws ClientException {
        return send(HttpMethod.PATCH, sourceProvisioningObjectSummary);
    }

    /**
     * Creates a ProvisioningObjectSummary with a new object
     *
     * @param newProvisioningObjectSummary the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ProvisioningObjectSummary> postAsync(@Nonnull final ProvisioningObjectSummary newProvisioningObjectSummary) {
        return sendAsync(HttpMethod.POST, newProvisioningObjectSummary);
    }

    /**
     * Creates a ProvisioningObjectSummary with a new object
     *
     * @param newProvisioningObjectSummary the new object to create
     * @return the created ProvisioningObjectSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ProvisioningObjectSummary post(@Nonnull final ProvisioningObjectSummary newProvisioningObjectSummary) throws ClientException {
        return send(HttpMethod.POST, newProvisioningObjectSummary);
    }

    /**
     * Creates a ProvisioningObjectSummary with a new object
     *
     * @param newProvisioningObjectSummary the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ProvisioningObjectSummary> putAsync(@Nonnull final ProvisioningObjectSummary newProvisioningObjectSummary) {
        return sendAsync(HttpMethod.PUT, newProvisioningObjectSummary);
    }

    /**
     * Creates a ProvisioningObjectSummary with a new object
     *
     * @param newProvisioningObjectSummary the object to create/update
     * @return the created ProvisioningObjectSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ProvisioningObjectSummary put(@Nonnull final ProvisioningObjectSummary newProvisioningObjectSummary) throws ClientException {
        return send(HttpMethod.PUT, newProvisioningObjectSummary);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ProvisioningObjectSummaryRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ProvisioningObjectSummaryRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

