// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrinterShare;
import com.microsoft.graph.requests.GroupCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.GroupWithReferenceRequestBuilder;
import com.microsoft.graph.requests.UserCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.UserWithReferenceRequestBuilder;
import com.microsoft.graph.requests.PrinterWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Printer Share Request.
 */
public class PrinterShareRequest extends BaseRequest<PrinterShare> {
	
    /**
     * The request for the PrinterShare
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrinterShareRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrinterShare.class);
    }

    /**
     * Gets the PrinterShare from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrinterShare> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PrinterShare from the service
     *
     * @return the PrinterShare from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrinterShare get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrinterShare> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PrinterShare delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrinterShare with a source
     *
     * @param sourcePrinterShare the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrinterShare> patchAsync(@Nonnull final PrinterShare sourcePrinterShare) {
        return sendAsync(HttpMethod.PATCH, sourcePrinterShare);
    }

    /**
     * Patches this PrinterShare with a source
     *
     * @param sourcePrinterShare the source object with updates
     * @return the updated PrinterShare
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrinterShare patch(@Nonnull final PrinterShare sourcePrinterShare) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrinterShare);
    }

    /**
     * Creates a PrinterShare with a new object
     *
     * @param newPrinterShare the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrinterShare> postAsync(@Nonnull final PrinterShare newPrinterShare) {
        return sendAsync(HttpMethod.POST, newPrinterShare);
    }

    /**
     * Creates a PrinterShare with a new object
     *
     * @param newPrinterShare the new object to create
     * @return the created PrinterShare
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrinterShare post(@Nonnull final PrinterShare newPrinterShare) throws ClientException {
        return send(HttpMethod.POST, newPrinterShare);
    }

    /**
     * Creates a PrinterShare with a new object
     *
     * @param newPrinterShare the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrinterShare> putAsync(@Nonnull final PrinterShare newPrinterShare) {
        return sendAsync(HttpMethod.PUT, newPrinterShare);
    }

    /**
     * Creates a PrinterShare with a new object
     *
     * @param newPrinterShare the object to create/update
     * @return the created PrinterShare
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrinterShare put(@Nonnull final PrinterShare newPrinterShare) throws ClientException {
        return send(HttpMethod.PUT, newPrinterShare);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PrinterShareRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PrinterShareRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

