// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrintOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Operation Request.
 */
public class PrintOperationRequest extends BaseRequest<PrintOperation> {
	
    /**
     * The request for the PrintOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public PrintOperationRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends PrintOperation> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the PrintOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintOperation.class);
    }

    /**
     * Gets the PrintOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PrintOperation from the service
     *
     * @return the PrintOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PrintOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrintOperation with a source
     *
     * @param sourcePrintOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintOperation> patchAsync(@Nonnull final PrintOperation sourcePrintOperation) {
        return sendAsync(HttpMethod.PATCH, sourcePrintOperation);
    }

    /**
     * Patches this PrintOperation with a source
     *
     * @param sourcePrintOperation the source object with updates
     * @return the updated PrintOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintOperation patch(@Nonnull final PrintOperation sourcePrintOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrintOperation);
    }

    /**
     * Creates a PrintOperation with a new object
     *
     * @param newPrintOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintOperation> postAsync(@Nonnull final PrintOperation newPrintOperation) {
        return sendAsync(HttpMethod.POST, newPrintOperation);
    }

    /**
     * Creates a PrintOperation with a new object
     *
     * @param newPrintOperation the new object to create
     * @return the created PrintOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintOperation post(@Nonnull final PrintOperation newPrintOperation) throws ClientException {
        return send(HttpMethod.POST, newPrintOperation);
    }

    /**
     * Creates a PrintOperation with a new object
     *
     * @param newPrintOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintOperation> putAsync(@Nonnull final PrintOperation newPrintOperation) {
        return sendAsync(HttpMethod.PUT, newPrintOperation);
    }

    /**
     * Creates a PrintOperation with a new object
     *
     * @param newPrintOperation the object to create/update
     * @return the created PrintOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintOperation put(@Nonnull final PrintOperation newPrintOperation) throws ClientException {
        return send(HttpMethod.PUT, newPrintOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PrintOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PrintOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

