// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.ParticipantStopHoldMusicRequest;
import com.microsoft.graph.models.Participant;
import com.microsoft.graph.models.StopHoldMusicOperation;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.ParticipantStopHoldMusicParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Participant Stop Hold Music Request Builder.
 */
public class ParticipantStopHoldMusicRequestBuilder extends BaseActionRequestBuilder<StopHoldMusicOperation> {

    /**
     * The request builder for this ParticipantStopHoldMusic
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ParticipantStopHoldMusicRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private ParticipantStopHoldMusicParameterSet body;
    /**
     * The request builder for this ParticipantStopHoldMusic
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public ParticipantStopHoldMusicRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final ParticipantStopHoldMusicParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the ParticipantStopHoldMusicRequest
     *
     * @param requestOptions the options for the request
     * @return the ParticipantStopHoldMusicRequest instance
     */
    @Nonnull
    public ParticipantStopHoldMusicRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the ParticipantStopHoldMusicRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the ParticipantStopHoldMusicRequest instance
     */
    @Nonnull
    public ParticipantStopHoldMusicRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final ParticipantStopHoldMusicRequest request = new ParticipantStopHoldMusicRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
