// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.OnenoteSection;
import com.microsoft.graph.models.OnenotePage;
import com.microsoft.graph.models.OnenoteOperation;
import com.microsoft.graph.models.OnenotePatchContentCommand;
import com.microsoft.graph.models.OnenotePagePreview;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.OnenotePageCollectionRequestBuilder;
import com.microsoft.graph.requests.OnenotePageRequestBuilder;
import com.microsoft.graph.requests.OnenotePageCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.PrimitiveRequestBuilder;
import com.microsoft.graph.models.OnenotePageCopyToSectionParameterSet;
import com.microsoft.graph.models.OnenotePageOnenotePatchContentParameterSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Onenote Page Collection Request Builder.
 */
public class OnenotePageCollectionRequestBuilder extends BaseCollectionRequestBuilder<OnenotePage, OnenotePageRequestBuilder, OnenotePageCollectionResponse, OnenotePageCollectionPage, OnenotePageCollectionRequest> {

    /**
     * The request builder for this collection of OnenoteSection
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OnenotePageCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OnenotePageRequestBuilder.class, OnenotePageCollectionRequest.class);
    }



    /**
     * Gets the raw count request for the collection
     * @return The raw count request for the collection
     */
    @Nonnull
    public PrimitiveRequestBuilder<Long> count() {
        return new PrimitiveRequestBuilder<Long>(getRequestUrlWithAdditionalSegment("$count"), getClient(), null, Long.class);
    }
}
