// Template Source: BaseMethodCollectionPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Message;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.http.DeltaCollectionPage;
import com.microsoft.graph.requests.MessageDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.MessageDeltaCollectionPage;
import com.microsoft.graph.requests.MessageDeltaCollectionResponse;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Message Delta Collection Page.
 */
public class MessageDeltaCollectionPage extends DeltaCollectionPage<Message, MessageDeltaCollectionRequestBuilder> {

    /**
     * A collection page for Message.
     *
     * @param response The serialized MessageDeltaCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public MessageDeltaCollectionPage(@Nonnull final MessageDeltaCollectionResponse response, @Nonnull final MessageDeltaCollectionRequestBuilder builder) {
       super(response, builder);
    }

	/**
     * Creates the collection page for MessageDelta
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public MessageDeltaCollectionPage(@Nonnull final java.util.List<Message> pageContents, @Nullable final MessageDeltaCollectionRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
