// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DirectoryRoleTemplate;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.ExtensionProperty;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Directory Role Template Request.
 */
public class DirectoryRoleTemplateRequest extends BaseRequest<DirectoryRoleTemplate> {
	
    /**
     * The request for the DirectoryRoleTemplate
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DirectoryRoleTemplateRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryRoleTemplate.class);
    }

    /**
     * Gets the DirectoryRoleTemplate from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DirectoryRoleTemplate> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DirectoryRoleTemplate from the service
     *
     * @return the DirectoryRoleTemplate from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DirectoryRoleTemplate get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DirectoryRoleTemplate> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DirectoryRoleTemplate delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DirectoryRoleTemplate with a source
     *
     * @param sourceDirectoryRoleTemplate the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DirectoryRoleTemplate> patchAsync(@Nonnull final DirectoryRoleTemplate sourceDirectoryRoleTemplate) {
        return sendAsync(HttpMethod.PATCH, sourceDirectoryRoleTemplate);
    }

    /**
     * Patches this DirectoryRoleTemplate with a source
     *
     * @param sourceDirectoryRoleTemplate the source object with updates
     * @return the updated DirectoryRoleTemplate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DirectoryRoleTemplate patch(@Nonnull final DirectoryRoleTemplate sourceDirectoryRoleTemplate) throws ClientException {
        return send(HttpMethod.PATCH, sourceDirectoryRoleTemplate);
    }

    /**
     * Creates a DirectoryRoleTemplate with a new object
     *
     * @param newDirectoryRoleTemplate the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DirectoryRoleTemplate> postAsync(@Nonnull final DirectoryRoleTemplate newDirectoryRoleTemplate) {
        return sendAsync(HttpMethod.POST, newDirectoryRoleTemplate);
    }

    /**
     * Creates a DirectoryRoleTemplate with a new object
     *
     * @param newDirectoryRoleTemplate the new object to create
     * @return the created DirectoryRoleTemplate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DirectoryRoleTemplate post(@Nonnull final DirectoryRoleTemplate newDirectoryRoleTemplate) throws ClientException {
        return send(HttpMethod.POST, newDirectoryRoleTemplate);
    }

    /**
     * Creates a DirectoryRoleTemplate with a new object
     *
     * @param newDirectoryRoleTemplate the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DirectoryRoleTemplate> putAsync(@Nonnull final DirectoryRoleTemplate newDirectoryRoleTemplate) {
        return sendAsync(HttpMethod.PUT, newDirectoryRoleTemplate);
    }

    /**
     * Creates a DirectoryRoleTemplate with a new object
     *
     * @param newDirectoryRoleTemplate the object to create/update
     * @return the created DirectoryRoleTemplate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DirectoryRoleTemplate put(@Nonnull final DirectoryRoleTemplate newDirectoryRoleTemplate) throws ClientException {
        return send(HttpMethod.PUT, newDirectoryRoleTemplate);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DirectoryRoleTemplateRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DirectoryRoleTemplateRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

