// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AndroidCompliancePolicy;
import com.microsoft.graph.models.DeviceCompliancePolicyAssignment;
import com.microsoft.graph.models.DeviceComplianceScheduledActionForRule;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Android Compliance Policy Request.
 */
public class AndroidCompliancePolicyRequest extends BaseRequest<AndroidCompliancePolicy> {
	
    /**
     * The request for the AndroidCompliancePolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AndroidCompliancePolicyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AndroidCompliancePolicy.class);
    }

    /**
     * Gets the AndroidCompliancePolicy from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidCompliancePolicy> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AndroidCompliancePolicy from the service
     *
     * @return the AndroidCompliancePolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AndroidCompliancePolicy get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidCompliancePolicy> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AndroidCompliancePolicy delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AndroidCompliancePolicy with a source
     *
     * @param sourceAndroidCompliancePolicy the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidCompliancePolicy> patchAsync(@Nonnull final AndroidCompliancePolicy sourceAndroidCompliancePolicy) {
        return sendAsync(HttpMethod.PATCH, sourceAndroidCompliancePolicy);
    }

    /**
     * Patches this AndroidCompliancePolicy with a source
     *
     * @param sourceAndroidCompliancePolicy the source object with updates
     * @return the updated AndroidCompliancePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AndroidCompliancePolicy patch(@Nonnull final AndroidCompliancePolicy sourceAndroidCompliancePolicy) throws ClientException {
        return send(HttpMethod.PATCH, sourceAndroidCompliancePolicy);
    }

    /**
     * Creates a AndroidCompliancePolicy with a new object
     *
     * @param newAndroidCompliancePolicy the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidCompliancePolicy> postAsync(@Nonnull final AndroidCompliancePolicy newAndroidCompliancePolicy) {
        return sendAsync(HttpMethod.POST, newAndroidCompliancePolicy);
    }

    /**
     * Creates a AndroidCompliancePolicy with a new object
     *
     * @param newAndroidCompliancePolicy the new object to create
     * @return the created AndroidCompliancePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AndroidCompliancePolicy post(@Nonnull final AndroidCompliancePolicy newAndroidCompliancePolicy) throws ClientException {
        return send(HttpMethod.POST, newAndroidCompliancePolicy);
    }

    /**
     * Creates a AndroidCompliancePolicy with a new object
     *
     * @param newAndroidCompliancePolicy the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidCompliancePolicy> putAsync(@Nonnull final AndroidCompliancePolicy newAndroidCompliancePolicy) {
        return sendAsync(HttpMethod.PUT, newAndroidCompliancePolicy);
    }

    /**
     * Creates a AndroidCompliancePolicy with a new object
     *
     * @param newAndroidCompliancePolicy the object to create/update
     * @return the created AndroidCompliancePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AndroidCompliancePolicy put(@Nonnull final AndroidCompliancePolicy newAndroidCompliancePolicy) throws ClientException {
        return send(HttpMethod.PUT, newAndroidCompliancePolicy);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AndroidCompliancePolicyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AndroidCompliancePolicyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

