// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.AccessReviewInstanceApplyDecisionsRequest;
import com.microsoft.graph.models.AccessReviewInstance;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Review Instance Apply Decisions Request Builder.
 */
public class AccessReviewInstanceApplyDecisionsRequestBuilder extends BaseActionRequestBuilder<AccessReviewInstance> {

    /**
     * The request builder for this AccessReviewInstanceApplyDecisions
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessReviewInstanceApplyDecisionsRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the AccessReviewInstanceApplyDecisionsRequest
     *
     * @param requestOptions the options for the request
     * @return the AccessReviewInstanceApplyDecisionsRequest instance
     */
    @Nonnull
    public AccessReviewInstanceApplyDecisionsRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the AccessReviewInstanceApplyDecisionsRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the AccessReviewInstanceApplyDecisionsRequest instance
     */
    @Nonnull
    public AccessReviewInstanceApplyDecisionsRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final AccessReviewInstanceApplyDecisionsRequest request = new AccessReviewInstanceApplyDecisionsRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
