// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessPackageAssignmentRequest;
import com.microsoft.graph.models.AccessPackageAssignmentRequestFilterByCurrentUserOptions;
import com.microsoft.graph.requests.AccessPackageWithReferenceRequestBuilder;
import com.microsoft.graph.requests.AccessPackageAssignmentWithReferenceRequestBuilder;
import com.microsoft.graph.requests.AccessPackageSubjectWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Assignment Request Request Builder.
 */
public class AccessPackageAssignmentRequestRequestBuilder extends BaseRequestBuilder<AccessPackageAssignmentRequest> {

    /**
     * The request builder for the AccessPackageAssignmentRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessPackageAssignmentRequestRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the AccessPackageAssignmentRequestRequest instance
     */
    @Nonnull
    public AccessPackageAssignmentRequestRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the AccessPackageAssignmentRequestRequest instance
     */
    @Nonnull
    public AccessPackageAssignmentRequestRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.AccessPackageAssignmentRequestRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for AccessPackage
     *
     * @return the AccessPackageWithReferenceRequestBuilder instance
     */
    @Nonnull
    public AccessPackageWithReferenceRequestBuilder accessPackage() {
        return new AccessPackageWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("accessPackage"), getClient(), null);
    }

    /**
     * Gets the request builder for AccessPackageAssignment
     *
     * @return the AccessPackageAssignmentWithReferenceRequestBuilder instance
     */
    @Nonnull
    public AccessPackageAssignmentWithReferenceRequestBuilder assignment() {
        return new AccessPackageAssignmentWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("assignment"), getClient(), null);
    }

    /**
     * Gets the request builder for AccessPackageSubject
     *
     * @return the AccessPackageSubjectWithReferenceRequestBuilder instance
     */
    @Nonnull
    public AccessPackageSubjectWithReferenceRequestBuilder requestor() {
        return new AccessPackageSubjectWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("requestor"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public AccessPackageAssignmentRequestCancelRequestBuilder cancel() {
        return new AccessPackageAssignmentRequestCancelRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.cancel"), getClient(), null);
    }
}
