// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Z_Test Parameter Set.
 */
public class WorkbookFunctionsZ_TestParameterSet {
    /**
     * The array.
     * 
     */
    @SerializedName(value = "array", alternate = {"Array"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement array;

    /**
     * The x.
     * 
     */
    @SerializedName(value = "x", alternate = {"X"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement x;

    /**
     * The sigma.
     * 
     */
    @SerializedName(value = "sigma", alternate = {"Sigma"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement sigma;


    /**
     * Instiaciates a new WorkbookFunctionsZ_TestParameterSet
     */
    public WorkbookFunctionsZ_TestParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsZ_TestParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsZ_TestParameterSet(@Nonnull final WorkbookFunctionsZ_TestParameterSetBuilder builder) {
        this.array = builder.array;
        this.x = builder.x;
        this.sigma = builder.sigma;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsZ_TestParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsZ_TestParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsZ_TestParameterSet
     */
    public static final class WorkbookFunctionsZ_TestParameterSetBuilder {
        /**
         * The array parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement array;
        /**
         * Sets the Array
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsZ_TestParameterSetBuilder withArray(@Nullable final com.google.gson.JsonElement val) {
            this.array = val;
            return this;
        }
        /**
         * The x parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement x;
        /**
         * Sets the X
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsZ_TestParameterSetBuilder withX(@Nullable final com.google.gson.JsonElement val) {
            this.x = val;
            return this;
        }
        /**
         * The sigma parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement sigma;
        /**
         * Sets the Sigma
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsZ_TestParameterSetBuilder withSigma(@Nullable final com.google.gson.JsonElement val) {
            this.sigma = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsZ_TestParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsZ_TestParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsZ_TestParameterSet build() {
            return new WorkbookFunctionsZ_TestParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.array != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("array", array));
        }
        if(this.x != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("x", x));
        }
        if(this.sigma != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("sigma", sigma));
        }
        return result;
    }
}
