// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Count If Parameter Set.
 */
public class WorkbookFunctionsCountIfParameterSet {
    /**
     * The range.
     * 
     */
    @SerializedName(value = "range", alternate = {"Range"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement range;

    /**
     * The criteria.
     * 
     */
    @SerializedName(value = "criteria", alternate = {"Criteria"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement criteria;


    /**
     * Instiaciates a new WorkbookFunctionsCountIfParameterSet
     */
    public WorkbookFunctionsCountIfParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsCountIfParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsCountIfParameterSet(@Nonnull final WorkbookFunctionsCountIfParameterSetBuilder builder) {
        this.range = builder.range;
        this.criteria = builder.criteria;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsCountIfParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsCountIfParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsCountIfParameterSet
     */
    public static final class WorkbookFunctionsCountIfParameterSetBuilder {
        /**
         * The range parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement range;
        /**
         * Sets the Range
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsCountIfParameterSetBuilder withRange(@Nullable final com.google.gson.JsonElement val) {
            this.range = val;
            return this;
        }
        /**
         * The criteria parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement criteria;
        /**
         * Sets the Criteria
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsCountIfParameterSetBuilder withCriteria(@Nullable final com.google.gson.JsonElement val) {
            this.criteria = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsCountIfParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsCountIfParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsCountIfParameterSet build() {
            return new WorkbookFunctionsCountIfParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.range != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("range", range));
        }
        if(this.criteria != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("criteria", criteria));
        }
        return result;
    }
}
