// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AppListType;
import com.microsoft.graph.models.AppListItem;
import com.microsoft.graph.models.RequiredPasswordType;
import com.microsoft.graph.models.DeviceConfiguration;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Phone81General Configuration.
 */
public class WindowsPhone81GeneralConfiguration extends DeviceConfiguration implements IJsonBackedObject {


    /**
     * The Apply Only To Windows Phone81.
     * Value indicating whether this policy only applies to Windows Phone 8.1. This property is read-only.
     */
    @SerializedName(value = "applyOnlyToWindowsPhone81", alternate = {"ApplyOnlyToWindowsPhone81"})
    @Expose
	@Nullable
    public Boolean applyOnlyToWindowsPhone81;

    /**
     * The Apps Block Copy Paste.
     * Indicates whether or not to block copy paste.
     */
    @SerializedName(value = "appsBlockCopyPaste", alternate = {"AppsBlockCopyPaste"})
    @Expose
	@Nullable
    public Boolean appsBlockCopyPaste;

    /**
     * The Bluetooth Blocked.
     * Indicates whether or not to block bluetooth.
     */
    @SerializedName(value = "bluetoothBlocked", alternate = {"BluetoothBlocked"})
    @Expose
	@Nullable
    public Boolean bluetoothBlocked;

    /**
     * The Camera Blocked.
     * Indicates whether or not to block camera.
     */
    @SerializedName(value = "cameraBlocked", alternate = {"CameraBlocked"})
    @Expose
	@Nullable
    public Boolean cameraBlocked;

    /**
     * The Cellular Block Wifi Tethering.
     * Indicates whether or not to block Wi-Fi tethering. Has no impact if Wi-Fi is blocked.
     */
    @SerializedName(value = "cellularBlockWifiTethering", alternate = {"CellularBlockWifiTethering"})
    @Expose
	@Nullable
    public Boolean cellularBlockWifiTethering;

    /**
     * The Compliant App List Type.
     * List that is in the AppComplianceList. Possible values are: none, appsInListCompliant, appsNotInListCompliant.
     */
    @SerializedName(value = "compliantAppListType", alternate = {"CompliantAppListType"})
    @Expose
	@Nullable
    public AppListType compliantAppListType;

    /**
     * The Compliant Apps List.
     * List of apps in the compliance (either allow list or block list, controlled by CompliantAppListType). This collection can contain a maximum of 10000 elements.
     */
    @SerializedName(value = "compliantAppsList", alternate = {"CompliantAppsList"})
    @Expose
	@Nullable
    public java.util.List<AppListItem> compliantAppsList;

    /**
     * The Diagnostic Data Block Submission.
     * Indicates whether or not to block diagnostic data submission.
     */
    @SerializedName(value = "diagnosticDataBlockSubmission", alternate = {"DiagnosticDataBlockSubmission"})
    @Expose
	@Nullable
    public Boolean diagnosticDataBlockSubmission;

    /**
     * The Email Block Adding Accounts.
     * Indicates whether or not to block custom email accounts.
     */
    @SerializedName(value = "emailBlockAddingAccounts", alternate = {"EmailBlockAddingAccounts"})
    @Expose
	@Nullable
    public Boolean emailBlockAddingAccounts;

    /**
     * The Location Services Blocked.
     * Indicates whether or not to block location services.
     */
    @SerializedName(value = "locationServicesBlocked", alternate = {"LocationServicesBlocked"})
    @Expose
	@Nullable
    public Boolean locationServicesBlocked;

    /**
     * The Microsoft Account Blocked.
     * Indicates whether or not to block using a Microsoft Account.
     */
    @SerializedName(value = "microsoftAccountBlocked", alternate = {"MicrosoftAccountBlocked"})
    @Expose
	@Nullable
    public Boolean microsoftAccountBlocked;

    /**
     * The Nfc Blocked.
     * Indicates whether or not to block Near-Field Communication.
     */
    @SerializedName(value = "nfcBlocked", alternate = {"NfcBlocked"})
    @Expose
	@Nullable
    public Boolean nfcBlocked;

    /**
     * The Password Block Simple.
     * Indicates whether or not to block syncing the calendar.
     */
    @SerializedName(value = "passwordBlockSimple", alternate = {"PasswordBlockSimple"})
    @Expose
	@Nullable
    public Boolean passwordBlockSimple;

    /**
     * The Password Expiration Days.
     * Number of days before the password expires.
     */
    @SerializedName(value = "passwordExpirationDays", alternate = {"PasswordExpirationDays"})
    @Expose
	@Nullable
    public Integer passwordExpirationDays;

    /**
     * The Password Minimum Character Set Count.
     * Number of character sets a password must contain.
     */
    @SerializedName(value = "passwordMinimumCharacterSetCount", alternate = {"PasswordMinimumCharacterSetCount"})
    @Expose
	@Nullable
    public Integer passwordMinimumCharacterSetCount;

    /**
     * The Password Minimum Length.
     * Minimum length of passwords.
     */
    @SerializedName(value = "passwordMinimumLength", alternate = {"PasswordMinimumLength"})
    @Expose
	@Nullable
    public Integer passwordMinimumLength;

    /**
     * The Password Minutes Of Inactivity Before Screen Timeout.
     * Minutes of inactivity before screen timeout.
     */
    @SerializedName(value = "passwordMinutesOfInactivityBeforeScreenTimeout", alternate = {"PasswordMinutesOfInactivityBeforeScreenTimeout"})
    @Expose
	@Nullable
    public Integer passwordMinutesOfInactivityBeforeScreenTimeout;

    /**
     * The Password Previous Password Block Count.
     * Number of previous passwords to block. Valid values 0 to 24
     */
    @SerializedName(value = "passwordPreviousPasswordBlockCount", alternate = {"PasswordPreviousPasswordBlockCount"})
    @Expose
	@Nullable
    public Integer passwordPreviousPasswordBlockCount;

    /**
     * The Password Required.
     * Indicates whether or not to require a password.
     */
    @SerializedName(value = "passwordRequired", alternate = {"PasswordRequired"})
    @Expose
	@Nullable
    public Boolean passwordRequired;

    /**
     * The Password Required Type.
     * Password type that is required. Possible values are: deviceDefault, alphanumeric, numeric.
     */
    @SerializedName(value = "passwordRequiredType", alternate = {"PasswordRequiredType"})
    @Expose
	@Nullable
    public RequiredPasswordType passwordRequiredType;

    /**
     * The Password Sign In Failure Count Before Factory Reset.
     * Number of sign in failures allowed before factory reset.
     */
    @SerializedName(value = "passwordSignInFailureCountBeforeFactoryReset", alternate = {"PasswordSignInFailureCountBeforeFactoryReset"})
    @Expose
	@Nullable
    public Integer passwordSignInFailureCountBeforeFactoryReset;

    /**
     * The Screen Capture Blocked.
     * Indicates whether or not to block screenshots.
     */
    @SerializedName(value = "screenCaptureBlocked", alternate = {"ScreenCaptureBlocked"})
    @Expose
	@Nullable
    public Boolean screenCaptureBlocked;

    /**
     * The Storage Block Removable Storage.
     * Indicates whether or not to block removable storage.
     */
    @SerializedName(value = "storageBlockRemovableStorage", alternate = {"StorageBlockRemovableStorage"})
    @Expose
	@Nullable
    public Boolean storageBlockRemovableStorage;

    /**
     * The Storage Require Encryption.
     * Indicates whether or not to require encryption.
     */
    @SerializedName(value = "storageRequireEncryption", alternate = {"StorageRequireEncryption"})
    @Expose
	@Nullable
    public Boolean storageRequireEncryption;

    /**
     * The Web Browser Blocked.
     * Indicates whether or not to block the web browser.
     */
    @SerializedName(value = "webBrowserBlocked", alternate = {"WebBrowserBlocked"})
    @Expose
	@Nullable
    public Boolean webBrowserBlocked;

    /**
     * The Wifi Block Automatic Connect Hotspots.
     * Indicates whether or not to block automatically connecting to Wi-Fi hotspots. Has no impact if Wi-Fi is blocked.
     */
    @SerializedName(value = "wifiBlockAutomaticConnectHotspots", alternate = {"WifiBlockAutomaticConnectHotspots"})
    @Expose
	@Nullable
    public Boolean wifiBlockAutomaticConnectHotspots;

    /**
     * The Wifi Blocked.
     * Indicates whether or not to block Wi-Fi.
     */
    @SerializedName(value = "wifiBlocked", alternate = {"WifiBlocked"})
    @Expose
	@Nullable
    public Boolean wifiBlocked;

    /**
     * The Wifi Block Hotspot Reporting.
     * Indicates whether or not to block Wi-Fi hotspot reporting. Has no impact if Wi-Fi is blocked.
     */
    @SerializedName(value = "wifiBlockHotspotReporting", alternate = {"WifiBlockHotspotReporting"})
    @Expose
	@Nullable
    public Boolean wifiBlockHotspotReporting;

    /**
     * The Windows Store Blocked.
     * Indicates whether or not to block the Windows Store.
     */
    @SerializedName(value = "windowsStoreBlocked", alternate = {"WindowsStoreBlocked"})
    @Expose
	@Nullable
    public Boolean windowsStoreBlocked;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
