// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Organizational Branding Properties.
 */
public class OrganizationalBrandingProperties extends Entity implements IJsonBackedObject {


    /**
     * The Background Color.
     * Color that will appear in place of the background image in low-bandwidth connections. We recommend that you use the primary color of your banner logo or your organization color. Specify this in hexadecimal format, for example, white is #FFFFFF.
     */
    @SerializedName(value = "backgroundColor", alternate = {"BackgroundColor"})
    @Expose
	@Nullable
    public String backgroundColor;

    /**
     * The Background Image Relative Url.
     * A relative URL for the backgroundImage property that is combined with a CDN base URL from the cdnList to provide the version served by a CDN. Read-only.
     */
    @SerializedName(value = "backgroundImageRelativeUrl", alternate = {"BackgroundImageRelativeUrl"})
    @Expose
	@Nullable
    public String backgroundImageRelativeUrl;

    /**
     * The Banner Logo Relative Url.
     * A relative url for the bannerLogo property that is combined with a CDN base URL from the cdnList to provide the read-only version served by a CDN. Read-only.
     */
    @SerializedName(value = "bannerLogoRelativeUrl", alternate = {"BannerLogoRelativeUrl"})
    @Expose
	@Nullable
    public String bannerLogoRelativeUrl;

    /**
     * The Cdn List.
     * A list of base URLs for all available CDN providers that are serving the assets of the current resource. Several CDN providers are used at the same time for high availability of read requests. Read-only.
     */
    @SerializedName(value = "cdnList", alternate = {"CdnList"})
    @Expose
	@Nullable
    public java.util.List<String> cdnList;

    /**
     * The Sign In Page Text.
     * Text that appears at the bottom of the sign-in box. You can use this to communicate additional information, such as the phone number to your help desk or a legal statement. This text must be Unicode and not exceed 1024 characters.
     */
    @SerializedName(value = "signInPageText", alternate = {"SignInPageText"})
    @Expose
	@Nullable
    public String signInPageText;

    /**
     * The Square Logo Relative Url.
     * A relative url for the squareLogo property that is combined with a CDN base URL from the cdnList to provide the version served by a CDN. Read-only.
     */
    @SerializedName(value = "squareLogoRelativeUrl", alternate = {"SquareLogoRelativeUrl"})
    @Expose
	@Nullable
    public String squareLogoRelativeUrl;

    /**
     * The Username Hint Text.
     * String that shows as the hint in the username textbox on the sign-in screen. This text must be a Unicode, without links or code, and can't exceed 64 characters.
     */
    @SerializedName(value = "usernameHintText", alternate = {"UsernameHintText"})
    @Expose
	@Nullable
    public String usernameHintText;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
