// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.ImportedWindowsAutopilotDeviceIdentityImportStatus;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Imported Windows Autopilot Device Identity State.
 */
public class ImportedWindowsAutopilotDeviceIdentityState implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Device Error Code.
     * Device error code reported by Device Directory Service(DDS).
     */
    @SerializedName(value = "deviceErrorCode", alternate = {"DeviceErrorCode"})
    @Expose
	@Nullable
    public Integer deviceErrorCode;

    /**
     * The Device Error Name.
     * Device error name reported by Device Directory Service(DDS).
     */
    @SerializedName(value = "deviceErrorName", alternate = {"DeviceErrorName"})
    @Expose
	@Nullable
    public String deviceErrorName;

    /**
     * The Device Import Status.
     * Device status reported by Device Directory Service(DDS). Possible values are: unknown, pending, partial, complete, error.
     */
    @SerializedName(value = "deviceImportStatus", alternate = {"DeviceImportStatus"})
    @Expose
	@Nullable
    public ImportedWindowsAutopilotDeviceIdentityImportStatus deviceImportStatus;

    /**
     * The Device Registration Id.
     * Device Registration ID for successfully added device reported by Device Directory Service(DDS).
     */
    @SerializedName(value = "deviceRegistrationId", alternate = {"DeviceRegistrationId"})
    @Expose
	@Nullable
    public String deviceRegistrationId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
