// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.ImportedWindowsAutopilotDeviceIdentityState;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Imported Windows Autopilot Device Identity.
 */
public class ImportedWindowsAutopilotDeviceIdentity extends Entity implements IJsonBackedObject {


    /**
     * The Assigned User Principal Name.
     * UPN of the user the device will be assigned
     */
    @SerializedName(value = "assignedUserPrincipalName", alternate = {"AssignedUserPrincipalName"})
    @Expose
	@Nullable
    public String assignedUserPrincipalName;

    /**
     * The Group Tag.
     * Group Tag of the Windows autopilot device.
     */
    @SerializedName(value = "groupTag", alternate = {"GroupTag"})
    @Expose
	@Nullable
    public String groupTag;

    /**
     * The Hardware Identifier.
     * Hardware Blob of the Windows autopilot device.
     */
    @SerializedName(value = "hardwareIdentifier", alternate = {"HardwareIdentifier"})
    @Expose
	@Nullable
    public byte[] hardwareIdentifier;

    /**
     * The Import Id.
     * The Import Id of the Windows autopilot device.
     */
    @SerializedName(value = "importId", alternate = {"ImportId"})
    @Expose
	@Nullable
    public String importId;

    /**
     * The Product Key.
     * Product Key of the Windows autopilot device.
     */
    @SerializedName(value = "productKey", alternate = {"ProductKey"})
    @Expose
	@Nullable
    public String productKey;

    /**
     * The Serial Number.
     * Serial number of the Windows autopilot device.
     */
    @SerializedName(value = "serialNumber", alternate = {"SerialNumber"})
    @Expose
	@Nullable
    public String serialNumber;

    /**
     * The State.
     * Current state of the imported device.
     */
    @SerializedName(value = "state", alternate = {"State"})
    @Expose
	@Nullable
    public ImportedWindowsAutopilotDeviceIdentityState state;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
