// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Domain Force Delete Parameter Set.
 */
public class DomainForceDeleteParameterSet {
    /**
     * The disable User Accounts.
     * 
     */
    @SerializedName(value = "disableUserAccounts", alternate = {"DisableUserAccounts"})
    @Expose
	@Nullable
    public Boolean disableUserAccounts;


    /**
     * Instiaciates a new DomainForceDeleteParameterSet
     */
    public DomainForceDeleteParameterSet() {}
    /**
     * Instiaciates a new DomainForceDeleteParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected DomainForceDeleteParameterSet(@Nonnull final DomainForceDeleteParameterSetBuilder builder) {
        this.disableUserAccounts = builder.disableUserAccounts;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static DomainForceDeleteParameterSetBuilder newBuilder() {
        return new DomainForceDeleteParameterSetBuilder();
    }
    /**
     * Fluent builder for the DomainForceDeleteParameterSet
     */
    public static final class DomainForceDeleteParameterSetBuilder {
        /**
         * The disableUserAccounts parameter value
         */
        @Nullable
        protected Boolean disableUserAccounts;
        /**
         * Sets the DisableUserAccounts
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public DomainForceDeleteParameterSetBuilder withDisableUserAccounts(@Nullable final Boolean val) {
            this.disableUserAccounts = val;
            return this;
        }
        /**
         * Instanciates a new DomainForceDeleteParameterSetBuilder
         */
        @Nullable
        protected DomainForceDeleteParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public DomainForceDeleteParameterSet build() {
            return new DomainForceDeleteParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.disableUserAccounts != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("disableUserAccounts", disableUserAccounts));
        }
        return result;
    }
}
