// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.ManagedEBook;
import com.microsoft.graph.models.MobileAppCategory;
import com.microsoft.graph.models.ManagedDeviceMobileAppConfiguration;
import com.microsoft.graph.models.MobileApp;
import com.microsoft.graph.models.VppToken;
import com.microsoft.graph.models.AndroidManagedAppProtection;
import com.microsoft.graph.models.DefaultManagedAppProtection;
import com.microsoft.graph.models.IosManagedAppProtection;
import com.microsoft.graph.models.ManagedAppPolicy;
import com.microsoft.graph.models.ManagedAppRegistration;
import com.microsoft.graph.models.ManagedAppStatus;
import com.microsoft.graph.models.MdmWindowsInformationProtectionPolicy;
import com.microsoft.graph.models.TargetedManagedAppConfiguration;
import com.microsoft.graph.models.WindowsInformationProtectionPolicy;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.ManagedEBookCollectionPage;
import com.microsoft.graph.requests.MobileAppCategoryCollectionPage;
import com.microsoft.graph.requests.ManagedDeviceMobileAppConfigurationCollectionPage;
import com.microsoft.graph.requests.MobileAppCollectionPage;
import com.microsoft.graph.requests.VppTokenCollectionPage;
import com.microsoft.graph.requests.AndroidManagedAppProtectionCollectionPage;
import com.microsoft.graph.requests.DefaultManagedAppProtectionCollectionPage;
import com.microsoft.graph.requests.IosManagedAppProtectionCollectionPage;
import com.microsoft.graph.requests.ManagedAppPolicyCollectionPage;
import com.microsoft.graph.requests.ManagedAppRegistrationCollectionPage;
import com.microsoft.graph.requests.ManagedAppStatusCollectionPage;
import com.microsoft.graph.requests.MdmWindowsInformationProtectionPolicyCollectionPage;
import com.microsoft.graph.requests.TargetedManagedAppConfigurationCollectionPage;
import com.microsoft.graph.requests.WindowsInformationProtectionPolicyCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device App Management.
 */
public class DeviceAppManagement extends Entity implements IJsonBackedObject {


    /**
     * The Is Enabled For Microsoft Store For Business.
     * Whether the account is enabled for syncing applications from the Microsoft Store for Business.
     */
    @SerializedName(value = "isEnabledForMicrosoftStoreForBusiness", alternate = {"IsEnabledForMicrosoftStoreForBusiness"})
    @Expose
	@Nullable
    public Boolean isEnabledForMicrosoftStoreForBusiness;

    /**
     * The Microsoft Store For Business Language.
     * The locale information used to sync applications from the Microsoft Store for Business. Cultures that are specific to a country/region. The names of these cultures follow RFC 4646 (Windows Vista and later). The format is -&amp;lt;country/regioncode2&amp;gt;, where  is a lowercase two-letter code derived from ISO 639-1 and &amp;lt;country/regioncode2&amp;gt; is an uppercase two-letter code derived from ISO 3166. For example, en-US for English (United States) is a specific culture.
     */
    @SerializedName(value = "microsoftStoreForBusinessLanguage", alternate = {"MicrosoftStoreForBusinessLanguage"})
    @Expose
	@Nullable
    public String microsoftStoreForBusinessLanguage;

    /**
     * The Microsoft Store For Business Last Completed Application Sync Time.
     * The last time an application sync from the Microsoft Store for Business was completed.
     */
    @SerializedName(value = "microsoftStoreForBusinessLastCompletedApplicationSyncTime", alternate = {"MicrosoftStoreForBusinessLastCompletedApplicationSyncTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime microsoftStoreForBusinessLastCompletedApplicationSyncTime;

    /**
     * The Microsoft Store For Business Last Successful Sync Date Time.
     * The last time the apps from the Microsoft Store for Business were synced successfully for the account.
     */
    @SerializedName(value = "microsoftStoreForBusinessLastSuccessfulSyncDateTime", alternate = {"MicrosoftStoreForBusinessLastSuccessfulSyncDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime microsoftStoreForBusinessLastSuccessfulSyncDateTime;

    /**
     * The Managed EBooks.
     * The Managed eBook.
     */
    @SerializedName(value = "managedEBooks", alternate = {"ManagedEBooks"})
    @Expose
	@Nullable
    public ManagedEBookCollectionPage managedEBooks;

    /**
     * The Mobile App Categories.
     * The mobile app categories.
     */
    @SerializedName(value = "mobileAppCategories", alternate = {"MobileAppCategories"})
    @Expose
	@Nullable
    public MobileAppCategoryCollectionPage mobileAppCategories;

    /**
     * The Mobile App Configurations.
     * The Managed Device Mobile Application Configurations.
     */
    @SerializedName(value = "mobileAppConfigurations", alternate = {"MobileAppConfigurations"})
    @Expose
	@Nullable
    public ManagedDeviceMobileAppConfigurationCollectionPage mobileAppConfigurations;

    /**
     * The Mobile Apps.
     * The mobile apps.
     */
    @SerializedName(value = "mobileApps", alternate = {"MobileApps"})
    @Expose
	@Nullable
    public MobileAppCollectionPage mobileApps;

    /**
     * The Vpp Tokens.
     * List of Vpp tokens for this organization.
     */
    @SerializedName(value = "vppTokens", alternate = {"VppTokens"})
    @Expose
	@Nullable
    public VppTokenCollectionPage vppTokens;

    /**
     * The Android Managed App Protections.
     * Android managed app policies.
     */
    @SerializedName(value = "androidManagedAppProtections", alternate = {"AndroidManagedAppProtections"})
    @Expose
	@Nullable
    public AndroidManagedAppProtectionCollectionPage androidManagedAppProtections;

    /**
     * The Default Managed App Protections.
     * Default managed app policies.
     */
    @SerializedName(value = "defaultManagedAppProtections", alternate = {"DefaultManagedAppProtections"})
    @Expose
	@Nullable
    public DefaultManagedAppProtectionCollectionPage defaultManagedAppProtections;

    /**
     * The Ios Managed App Protections.
     * iOS managed app policies.
     */
    @SerializedName(value = "iosManagedAppProtections", alternate = {"IosManagedAppProtections"})
    @Expose
	@Nullable
    public IosManagedAppProtectionCollectionPage iosManagedAppProtections;

    /**
     * The Managed App Policies.
     * Managed app policies.
     */
    @SerializedName(value = "managedAppPolicies", alternate = {"ManagedAppPolicies"})
    @Expose
	@Nullable
    public ManagedAppPolicyCollectionPage managedAppPolicies;

    /**
     * The Managed App Registrations.
     * The managed app registrations.
     */
    @SerializedName(value = "managedAppRegistrations", alternate = {"ManagedAppRegistrations"})
    @Expose
	@Nullable
    public ManagedAppRegistrationCollectionPage managedAppRegistrations;

    /**
     * The Managed App Statuses.
     * The managed app statuses.
     */
    @SerializedName(value = "managedAppStatuses", alternate = {"ManagedAppStatuses"})
    @Expose
	@Nullable
    public ManagedAppStatusCollectionPage managedAppStatuses;

    /**
     * The Mdm Windows Information Protection Policies.
     * Windows information protection for apps running on devices which are MDM enrolled.
     */
    @SerializedName(value = "mdmWindowsInformationProtectionPolicies", alternate = {"MdmWindowsInformationProtectionPolicies"})
    @Expose
	@Nullable
    public MdmWindowsInformationProtectionPolicyCollectionPage mdmWindowsInformationProtectionPolicies;

    /**
     * The Targeted Managed App Configurations.
     * Targeted managed app configurations.
     */
    @SerializedName(value = "targetedManagedAppConfigurations", alternate = {"TargetedManagedAppConfigurations"})
    @Expose
	@Nullable
    public TargetedManagedAppConfigurationCollectionPage targetedManagedAppConfigurations;

    /**
     * The Windows Information Protection Policies.
     * Windows information protection for apps running on devices which are not MDM enrolled.
     */
    @SerializedName(value = "windowsInformationProtectionPolicies", alternate = {"WindowsInformationProtectionPolicies"})
    @Expose
	@Nullable
    public WindowsInformationProtectionPolicyCollectionPage windowsInformationProtectionPolicies;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("managedEBooks")) {
            managedEBooks = serializer.deserializeObject(json.get("managedEBooks"), ManagedEBookCollectionPage.class);
        }

        if (json.has("mobileAppCategories")) {
            mobileAppCategories = serializer.deserializeObject(json.get("mobileAppCategories"), MobileAppCategoryCollectionPage.class);
        }

        if (json.has("mobileAppConfigurations")) {
            mobileAppConfigurations = serializer.deserializeObject(json.get("mobileAppConfigurations"), ManagedDeviceMobileAppConfigurationCollectionPage.class);
        }

        if (json.has("mobileApps")) {
            mobileApps = serializer.deserializeObject(json.get("mobileApps"), MobileAppCollectionPage.class);
        }

        if (json.has("vppTokens")) {
            vppTokens = serializer.deserializeObject(json.get("vppTokens"), VppTokenCollectionPage.class);
        }

        if (json.has("androidManagedAppProtections")) {
            androidManagedAppProtections = serializer.deserializeObject(json.get("androidManagedAppProtections"), AndroidManagedAppProtectionCollectionPage.class);
        }

        if (json.has("defaultManagedAppProtections")) {
            defaultManagedAppProtections = serializer.deserializeObject(json.get("defaultManagedAppProtections"), DefaultManagedAppProtectionCollectionPage.class);
        }

        if (json.has("iosManagedAppProtections")) {
            iosManagedAppProtections = serializer.deserializeObject(json.get("iosManagedAppProtections"), IosManagedAppProtectionCollectionPage.class);
        }

        if (json.has("managedAppPolicies")) {
            managedAppPolicies = serializer.deserializeObject(json.get("managedAppPolicies"), ManagedAppPolicyCollectionPage.class);
        }

        if (json.has("managedAppRegistrations")) {
            managedAppRegistrations = serializer.deserializeObject(json.get("managedAppRegistrations"), ManagedAppRegistrationCollectionPage.class);
        }

        if (json.has("managedAppStatuses")) {
            managedAppStatuses = serializer.deserializeObject(json.get("managedAppStatuses"), ManagedAppStatusCollectionPage.class);
        }

        if (json.has("mdmWindowsInformationProtectionPolicies")) {
            mdmWindowsInformationProtectionPolicies = serializer.deserializeObject(json.get("mdmWindowsInformationProtectionPolicies"), MdmWindowsInformationProtectionPolicyCollectionPage.class);
        }

        if (json.has("targetedManagedAppConfigurations")) {
            targetedManagedAppConfigurations = serializer.deserializeObject(json.get("targetedManagedAppConfigurations"), TargetedManagedAppConfigurationCollectionPage.class);
        }

        if (json.has("windowsInformationProtectionPolicies")) {
            windowsInformationProtectionPolicies = serializer.deserializeObject(json.get("windowsInformationProtectionPolicies"), WindowsInformationProtectionPolicyCollectionPage.class);
        }
    }
}
