// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.ManagedAppDataEncryptionType;
import com.microsoft.graph.models.KeyValuePair;
import com.microsoft.graph.models.ManagedMobileApp;
import com.microsoft.graph.models.ManagedAppPolicyDeploymentSummary;
import com.microsoft.graph.models.ManagedAppProtection;
import com.microsoft.graph.requests.ManagedMobileAppCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Default Managed App Protection.
 */
public class DefaultManagedAppProtection extends ManagedAppProtection implements IJsonBackedObject {


    /**
     * The App Data Encryption Type.
     * Type of encryption which should be used for data in a managed app. (iOS Only). Possible values are: useDeviceSettings, afterDeviceRestart, whenDeviceLockedExceptOpenFiles, whenDeviceLocked.
     */
    @SerializedName(value = "appDataEncryptionType", alternate = {"AppDataEncryptionType"})
    @Expose
	@Nullable
    public ManagedAppDataEncryptionType appDataEncryptionType;

    /**
     * The Custom Settings.
     * A set of string key and string value pairs to be sent to the affected users, unalterned by this service
     */
    @SerializedName(value = "customSettings", alternate = {"CustomSettings"})
    @Expose
	@Nullable
    public java.util.List<KeyValuePair> customSettings;

    /**
     * The Deployed App Count.
     * Count of apps to which the current policy is deployed.
     */
    @SerializedName(value = "deployedAppCount", alternate = {"DeployedAppCount"})
    @Expose
	@Nullable
    public Integer deployedAppCount;

    /**
     * The Disable App Encryption If Device Encryption Is Enabled.
     * When this setting is enabled, app level encryption is disabled if device level encryption is enabled. (Android only)
     */
    @SerializedName(value = "disableAppEncryptionIfDeviceEncryptionIsEnabled", alternate = {"DisableAppEncryptionIfDeviceEncryptionIsEnabled"})
    @Expose
	@Nullable
    public Boolean disableAppEncryptionIfDeviceEncryptionIsEnabled;

    /**
     * The Encrypt App Data.
     * Indicates whether managed-app data should be encrypted. (Android only)
     */
    @SerializedName(value = "encryptAppData", alternate = {"EncryptAppData"})
    @Expose
	@Nullable
    public Boolean encryptAppData;

    /**
     * The Face Id Blocked.
     * Indicates whether use of the FaceID is allowed in place of a pin if PinRequired is set to True. (iOS Only)
     */
    @SerializedName(value = "faceIdBlocked", alternate = {"FaceIdBlocked"})
    @Expose
	@Nullable
    public Boolean faceIdBlocked;

    /**
     * The Minimum Required Patch Version.
     * Define the oldest required Android security patch level a user can have to gain secure access to the app. (Android only)
     */
    @SerializedName(value = "minimumRequiredPatchVersion", alternate = {"MinimumRequiredPatchVersion"})
    @Expose
	@Nullable
    public String minimumRequiredPatchVersion;

    /**
     * The Minimum Required Sdk Version.
     * Versions less than the specified version will block the managed app from accessing company data. (iOS Only)
     */
    @SerializedName(value = "minimumRequiredSdkVersion", alternate = {"MinimumRequiredSdkVersion"})
    @Expose
	@Nullable
    public String minimumRequiredSdkVersion;

    /**
     * The Minimum Warning Patch Version.
     * Define the oldest recommended Android security patch level a user can have for secure access to the app. (Android only)
     */
    @SerializedName(value = "minimumWarningPatchVersion", alternate = {"MinimumWarningPatchVersion"})
    @Expose
	@Nullable
    public String minimumWarningPatchVersion;

    /**
     * The Screen Capture Blocked.
     * Indicates whether screen capture is blocked. (Android only)
     */
    @SerializedName(value = "screenCaptureBlocked", alternate = {"ScreenCaptureBlocked"})
    @Expose
	@Nullable
    public Boolean screenCaptureBlocked;

    /**
     * The Apps.
     * List of apps to which the policy is deployed.
     */
    @SerializedName(value = "apps", alternate = {"Apps"})
    @Expose
	@Nullable
    public ManagedMobileAppCollectionPage apps;

    /**
     * The Deployment Summary.
     * Navigation property to deployment summary of the configuration.
     */
    @SerializedName(value = "deploymentSummary", alternate = {"DeploymentSummary"})
    @Expose
	@Nullable
    public ManagedAppPolicyDeploymentSummary deploymentSummary;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("apps")) {
            apps = serializer.deserializeObject(json.get("apps"), ManagedMobileAppCollectionPage.class);
        }
    }
}
