// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.RecordingStatus;
import com.microsoft.graph.models.UpdateRecordingStatusOperation;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Update Recording Status Parameter Set.
 */
public class CallUpdateRecordingStatusParameterSet {
    /**
     * The status.
     * 
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public RecordingStatus status;

    /**
     * The client Context.
     * 
     */
    @SerializedName(value = "clientContext", alternate = {"ClientContext"})
    @Expose
	@Nullable
    public String clientContext;


    /**
     * Instiaciates a new CallUpdateRecordingStatusParameterSet
     */
    public CallUpdateRecordingStatusParameterSet() {}
    /**
     * Instiaciates a new CallUpdateRecordingStatusParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected CallUpdateRecordingStatusParameterSet(@Nonnull final CallUpdateRecordingStatusParameterSetBuilder builder) {
        this.status = builder.status;
        this.clientContext = builder.clientContext;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static CallUpdateRecordingStatusParameterSetBuilder newBuilder() {
        return new CallUpdateRecordingStatusParameterSetBuilder();
    }
    /**
     * Fluent builder for the CallUpdateRecordingStatusParameterSet
     */
    public static final class CallUpdateRecordingStatusParameterSetBuilder {
        /**
         * The status parameter value
         */
        @Nullable
        protected RecordingStatus status;
        /**
         * Sets the Status
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CallUpdateRecordingStatusParameterSetBuilder withStatus(@Nullable final RecordingStatus val) {
            this.status = val;
            return this;
        }
        /**
         * The clientContext parameter value
         */
        @Nullable
        protected String clientContext;
        /**
         * Sets the ClientContext
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CallUpdateRecordingStatusParameterSetBuilder withClientContext(@Nullable final String val) {
            this.clientContext = val;
            return this;
        }
        /**
         * Instanciates a new CallUpdateRecordingStatusParameterSetBuilder
         */
        @Nullable
        protected CallUpdateRecordingStatusParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public CallUpdateRecordingStatusParameterSet build() {
            return new CallUpdateRecordingStatusParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.status != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("status", status));
        }
        if(this.clientContext != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("clientContext", clientContext));
        }
        return result;
    }
}
