// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.TeleconferenceDeviceQuality;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Log Teleconference Device Quality Parameter Set.
 */
public class CallLogTeleconferenceDeviceQualityParameterSet {
    /**
     * The quality.
     * 
     */
    @SerializedName(value = "quality", alternate = {"Quality"})
    @Expose
	@Nullable
    public TeleconferenceDeviceQuality quality;


    /**
     * Instiaciates a new CallLogTeleconferenceDeviceQualityParameterSet
     */
    public CallLogTeleconferenceDeviceQualityParameterSet() {}
    /**
     * Instiaciates a new CallLogTeleconferenceDeviceQualityParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected CallLogTeleconferenceDeviceQualityParameterSet(@Nonnull final CallLogTeleconferenceDeviceQualityParameterSetBuilder builder) {
        this.quality = builder.quality;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static CallLogTeleconferenceDeviceQualityParameterSetBuilder newBuilder() {
        return new CallLogTeleconferenceDeviceQualityParameterSetBuilder();
    }
    /**
     * Fluent builder for the CallLogTeleconferenceDeviceQualityParameterSet
     */
    public static final class CallLogTeleconferenceDeviceQualityParameterSetBuilder {
        /**
         * The quality parameter value
         */
        @Nullable
        protected TeleconferenceDeviceQuality quality;
        /**
         * Sets the Quality
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CallLogTeleconferenceDeviceQualityParameterSetBuilder withQuality(@Nullable final TeleconferenceDeviceQuality val) {
            this.quality = val;
            return this;
        }
        /**
         * Instanciates a new CallLogTeleconferenceDeviceQualityParameterSetBuilder
         */
        @Nullable
        protected CallLogTeleconferenceDeviceQualityParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public CallLogTeleconferenceDeviceQualityParameterSet build() {
            return new CallLogTeleconferenceDeviceQualityParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.quality != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("quality", quality));
        }
        return result;
    }
}
