// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AccessPackageSubjectType;
import com.microsoft.graph.models.ConnectedOrganization;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Subject.
 */
public class AccessPackageSubject extends Entity implements IJsonBackedObject {


    /**
     * The Display Name.
     * The display name of the subject.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Email.
     * The email address of the subject.
     */
    @SerializedName(value = "email", alternate = {"Email"})
    @Expose
	@Nullable
    public String email;

    /**
     * The Object Id.
     * The object identifier of the subject. null if the subject is not yet a user in the tenant.
     */
    @SerializedName(value = "objectId", alternate = {"ObjectId"})
    @Expose
	@Nullable
    public String objectId;

    /**
     * The On Premises Security Identifier.
     * A string representation of the principal's security identifier, if known, or null if the subject does not have a security identifier.
     */
    @SerializedName(value = "onPremisesSecurityIdentifier", alternate = {"OnPremisesSecurityIdentifier"})
    @Expose
	@Nullable
    public String onPremisesSecurityIdentifier;

    /**
     * The Principal Name.
     * The principal name, if known, of the subject.
     */
    @SerializedName(value = "principalName", alternate = {"PrincipalName"})
    @Expose
	@Nullable
    public String principalName;

    /**
     * The Subject Type.
     * The resource type of the subject. The possible values are: notSpecified, user, servicePrincipal, unknownFutureValue.
     */
    @SerializedName(value = "subjectType", alternate = {"SubjectType"})
    @Expose
	@Nullable
    public AccessPackageSubjectType subjectType;

    /**
     * The Connected Organization.
     * The connected organization of the subject. Read-only. Nullable.
     */
    @SerializedName(value = "connectedOrganization", alternate = {"ConnectedOrganization"})
    @Expose
	@Nullable
    public ConnectedOrganization connectedOrganization;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
