/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.DriveSearchParameterSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.DriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveItemRequestBuilder;
import com.microsoft.graph.requests.DriveRecentCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveRequest;
import com.microsoft.graph.requests.DriveSearchCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveSharedWithMeCollectionRequestBuilder;
import com.microsoft.graph.requests.ListRequestBuilder;
import com.microsoft.graph.requests.UserWithReferenceRequestBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DriveRequestBuilder
extends BaseRequestBuilder<Drive> {
    public DriveRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Nonnull
    public DriveRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public DriveRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        return new DriveRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Nonnull
    public UserWithReferenceRequestBuilder createdByUser() {
        return new UserWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("createdByUser"), this.getClient(), null);
    }

    @Nonnull
    public UserWithReferenceRequestBuilder lastModifiedByUser() {
        return new UserWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("lastModifiedByUser"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemCollectionRequestBuilder bundles() {
        return new DriveItemCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("bundles"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemRequestBuilder bundles(@Nonnull String id) {
        return new DriveItemRequestBuilder(this.getRequestUrlWithAdditionalSegment("bundles") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public DriveItemCollectionRequestBuilder following() {
        return new DriveItemCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("following"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemRequestBuilder following(@Nonnull String id) {
        return new DriveItemRequestBuilder(this.getRequestUrlWithAdditionalSegment("following") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public DriveItemCollectionRequestBuilder items() {
        return new DriveItemCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("items"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemRequestBuilder items(@Nonnull String id) {
        return new DriveItemRequestBuilder(this.getRequestUrlWithAdditionalSegment("items") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public ListRequestBuilder list() {
        return new ListRequestBuilder(this.getRequestUrlWithAdditionalSegment("list"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemRequestBuilder root() {
        return new DriveItemRequestBuilder(this.getRequestUrlWithAdditionalSegment("root"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemCollectionRequestBuilder special() {
        return new DriveItemCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("special"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemRequestBuilder special(@Nonnull String id) {
        return new DriveItemRequestBuilder(this.getRequestUrlWithAdditionalSegment("special") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public DriveSearchCollectionRequestBuilder search(@Nonnull DriveSearchParameterSet parameters) {
        return new DriveSearchCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.search"), this.getClient(), null, parameters);
    }

    @Nonnull
    public DriveRecentCollectionRequestBuilder recent() {
        return new DriveRecentCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.recent"), this.getClient(), null);
    }

    @Nonnull
    public DriveSharedWithMeCollectionRequestBuilder sharedWithMe() {
        return new DriveSharedWithMeCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.sharedWithMe"), this.getClient(), null);
    }
}

