/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.Todo;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TodoRequest
extends BaseRequest<Todo> {
    public TodoRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Todo.class);
    }

    @Nonnull
    public CompletableFuture<Todo> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Todo get() throws ClientException {
        return (Todo)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Todo> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Todo delete() throws ClientException {
        return (Todo)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Todo> patchAsync(@Nonnull Todo sourceTodo) {
        return this.sendAsync(HttpMethod.PATCH, sourceTodo);
    }

    @Nullable
    public Todo patch(@Nonnull Todo sourceTodo) throws ClientException {
        return (Todo)this.send(HttpMethod.PATCH, sourceTodo);
    }

    @Nonnull
    public CompletableFuture<Todo> postAsync(@Nonnull Todo newTodo) {
        return this.sendAsync(HttpMethod.POST, newTodo);
    }

    @Nullable
    public Todo post(@Nonnull Todo newTodo) throws ClientException {
        return (Todo)this.send(HttpMethod.POST, newTodo);
    }

    @Nonnull
    public CompletableFuture<Todo> putAsync(@Nonnull Todo newTodo) {
        return this.sendAsync(HttpMethod.PUT, newTodo);
    }

    @Nullable
    public Todo put(@Nonnull Todo newTodo) throws ClientException {
        return (Todo)this.send(HttpMethod.PUT, newTodo);
    }

    @Nonnull
    public TodoRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public TodoRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

