/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.ColumnDefinition;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ColumnDefinitionReferenceRequest
extends BaseReferenceRequest<ColumnDefinition> {
    public ColumnDefinitionReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ColumnDefinition.class);
    }

    @Nonnull
    public ColumnDefinitionReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ColumnDefinitionReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<ColumnDefinition> putAsync(@Nonnull ColumnDefinition srcColumnDefinition) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/sharedColumns/" + srcColumnDefinition.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public ColumnDefinition put(@Nonnull ColumnDefinition srcColumnDefinition) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/sharedColumns/" + srcColumnDefinition.id));
        return (ColumnDefinition)this.send(HttpMethod.PUT, payload);
    }
}

