/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.AccessPackage;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AccessPackageReferenceRequest
extends BaseReferenceRequest<AccessPackage> {
    public AccessPackageReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessPackage.class);
    }

    @Nonnull
    public AccessPackageReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public AccessPackageReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<AccessPackage> putAsync(@Nonnull AccessPackage srcAccessPackage) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/identityGovernance/entitlementManagement/{id}/accessPackages/" + srcAccessPackage.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public AccessPackage put(@Nonnull AccessPackage srcAccessPackage) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/identityGovernance/entitlementManagement/{id}/accessPackages/" + srcAccessPackage.id));
        return (AccessPackage)this.send(HttpMethod.PUT, payload);
    }
}

