/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.IdentityProvider;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.IdentityProviderCollectionPage;
import com.microsoft.graph.requests.IdentityProviderCollectionRequestBuilder;
import com.microsoft.graph.requests.IdentityProviderCollectionResponse;
import com.microsoft.graph.requests.IdentityProviderRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IdentityProviderCollectionRequest
extends BaseEntityCollectionRequest<IdentityProvider, IdentityProviderCollectionResponse, IdentityProviderCollectionPage> {
    public IdentityProviderCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, IdentityProviderCollectionResponse.class, IdentityProviderCollectionPage.class, IdentityProviderCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<IdentityProvider> postAsync(@Nonnull IdentityProvider newIdentityProvider) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new IdentityProviderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newIdentityProvider);
    }

    @Nonnull
    public IdentityProvider post(@Nonnull IdentityProvider newIdentityProvider) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new IdentityProviderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newIdentityProvider);
    }

    @Nonnull
    public IdentityProviderCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public IdentityProviderCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public IdentityProviderCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public IdentityProviderCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public IdentityProviderCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public IdentityProviderCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public IdentityProviderCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public IdentityProviderCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public IdentityProviderCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

