/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.requests.upload;

import com.microsoft.graph.core.models.IUploadSession;
import com.microsoft.graph.core.models.UploadResult;
import com.microsoft.graph.core.requests.upload.UploadResponseHandler;
import com.microsoft.kiota.Compatibility;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.NativeResponseHandler;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.ResponseHandler;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.Objects;
import okhttp3.Response;

public class UploadSessionRequestBuilder<T extends Parsable> {
    private final UploadResponseHandler responseHandler = new UploadResponseHandler();
    private final RequestAdapter requestAdapter;
    private final String urlTemplate;
    private final ParsableFactory<T> factory;

    public UploadSessionRequestBuilder(@Nonnull String sessionUrl, @Nonnull RequestAdapter requestAdapter, @Nonnull ParsableFactory<T> factory) {
        this.requestAdapter = Objects.requireNonNull(requestAdapter);
        if (Compatibility.isBlank((String)sessionUrl)) {
            throw new IllegalArgumentException("sessionUrl cannot be null or empty");
        }
        this.urlTemplate = sessionUrl;
        this.factory = Objects.requireNonNull(factory);
    }

    @Nonnull
    public IUploadSession get() {
        RequestInformation requestInformation = this.toGetRequestInformation();
        NativeResponseHandler nativeResponseHandler = new NativeResponseHandler();
        requestInformation.setResponseHandler((ResponseHandler)nativeResponseHandler);
        this.requestAdapter.sendPrimitive(requestInformation, null, InputStream.class);
        UploadResult<T> result = this.responseHandler.handleResponse((Response)nativeResponseHandler.getValue(), this.factory);
        return result.uploadSession;
    }

    private RequestInformation toGetRequestInformation() {
        RequestInformation requestInformation = new RequestInformation();
        requestInformation.httpMethod = HttpMethod.GET;
        requestInformation.urlTemplate = this.urlTemplate;
        return requestInformation;
    }

    public void delete() {
        RequestInformation requestInfo = this.toDeleteRequestInformation();
        this.requestAdapter.sendPrimitive(requestInfo, null, Void.class);
    }

    private RequestInformation toDeleteRequestInformation() {
        RequestInformation requestInformation = new RequestInformation();
        requestInformation.httpMethod = HttpMethod.DELETE;
        requestInformation.urlTemplate = this.urlTemplate;
        return requestInformation;
    }
}

