/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.requests.options;

import com.microsoft.graph.core.CoreConstants;
import com.microsoft.graph.core.requests.FeatureTracker;
import com.microsoft.kiota.Compatibility;
import com.microsoft.kiota.RequestOption;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.UUID;

public class GraphClientOption
implements RequestOption {
    private String clientRequestId;
    private String clientLibraryVersion;
    private String coreLibraryVersion;
    private String graphServiceTargetVersion;
    public final FeatureTracker featureTracker = new FeatureTracker();

    public void setClientRequestId(@Nonnull String clientRequestId) {
        if (Compatibility.isBlank((String)clientRequestId)) {
            throw new IllegalArgumentException("clientRequestId cannot be null or empty");
        }
        this.clientRequestId = clientRequestId;
    }

    @Nonnull
    public String getClientRequestId() {
        if (this.clientRequestId == null) {
            this.clientRequestId = UUID.randomUUID().toString();
        }
        return this.clientRequestId;
    }

    public void setClientLibraryVersion(@Nonnull String clientLibraryVersion) {
        if (Compatibility.isBlank((String)clientLibraryVersion)) {
            throw new IllegalArgumentException("clientLibraryVersion cannot be null or empty");
        }
        this.clientLibraryVersion = clientLibraryVersion;
    }

    @Nullable
    public String getClientLibraryVersion() {
        return this.clientLibraryVersion == null ? null : this.clientLibraryVersion;
    }

    public void setCoreLibraryVersion(@Nonnull String coreLibraryVersion) {
        if (Compatibility.isBlank((String)coreLibraryVersion)) {
            throw new IllegalArgumentException("coreLibraryVersion cannot be null or empty");
        }
        this.coreLibraryVersion = coreLibraryVersion;
    }

    @Nonnull
    public String getCoreLibraryVersion() {
        return this.coreLibraryVersion == null ? CoreConstants.Headers.VERSION : this.coreLibraryVersion;
    }

    public void setGraphServiceTargetVersion(@Nonnull String graphServiceVersion) {
        if (Compatibility.isBlank((String)graphServiceVersion)) {
            throw new IllegalArgumentException("graphServiceVersion cannot be null or empty");
        }
        this.graphServiceTargetVersion = graphServiceVersion;
    }

    @Nonnull
    public String getGraphServiceTargetVersion() {
        return this.graphServiceTargetVersion == null ? "v1.0" : this.graphServiceTargetVersion;
    }

    @Nonnull
    public <T extends RequestOption> Class<T> getType() {
        return GraphClientOption.class;
    }
}

