/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.requests;

import com.microsoft.graph.core.content.BatchRequestContent;
import com.microsoft.graph.core.content.BatchRequestContentCollection;
import com.microsoft.graph.core.content.BatchResponseContent;
import com.microsoft.graph.core.content.BatchResponseContentCollection;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.NativeResponseHandler;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.ResponseHandler;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Response;

public class BatchRequestBuilder {
    private final RequestAdapter requestAdapter;

    public BatchRequestBuilder(@Nonnull RequestAdapter requestAdapter) {
        this.requestAdapter = Objects.requireNonNull(requestAdapter, "The following parameter cannot be null: requestAdapter");
    }

    @Nonnull
    public BatchResponseContent post(@Nonnull BatchRequestContent requestContent, @Nullable Map<String, ParsableFactory<? extends Parsable>> errorMappings) throws IOException {
        Objects.requireNonNull(requestContent, "The following parameter cannot be null: requestContent");
        RequestInformation requestInfo = this.toPostRequestInformation(requestContent);
        NativeResponseHandler nativeResponseHandler = new NativeResponseHandler();
        requestInfo.setResponseHandler((ResponseHandler)nativeResponseHandler);
        this.requestAdapter.sendPrimitive(requestInfo, (HashMap)(errorMappings == null ? null : new HashMap<String, ParsableFactory<? extends Parsable>>(errorMappings)), InputStream.class);
        return new BatchResponseContent((Response)nativeResponseHandler.getValue(), errorMappings);
    }

    @Nonnull
    public BatchResponseContentCollection post(@Nonnull BatchRequestContentCollection batchRequestContentCollection, @Nullable Map<String, ParsableFactory<? extends Parsable>> errorMappings) throws IOException {
        BatchResponseContentCollection collection = new BatchResponseContentCollection();
        List<BatchRequestContent> requests = batchRequestContentCollection.getBatchRequestsForExecution();
        for (BatchRequestContent request : requests) {
            BatchResponseContent responseContent = this.post(request, errorMappings);
            collection.addBatchResponse(request.getBatchRequestSteps().keySet(), responseContent);
        }
        return collection;
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull BatchRequestContent requestContent) throws IOException {
        Objects.requireNonNull(requestContent, "The following parameter cannot be null: requestContent");
        RequestInformation requestInfo = new RequestInformation();
        requestInfo.httpMethod = HttpMethod.POST;
        requestInfo.urlTemplate = "{+baseurl}/$batch";
        requestInfo.content = requestContent.getBatchRequestContent();
        requestInfo.headers.add("Content-Type", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestAdapter getRequestAdapter() {
        return this.requestAdapter;
    }
}

