/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BaseReferenceRequestBuilder<T, T2 extends BaseReferenceRequest<T>>
extends BaseRequestBuilder<T> {
    private Class<T2> refRequestClass;

    public BaseReferenceRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions, @Nonnull Class<T2> referenceRequestClass) {
        super(requestUrl, client, requestOptions);
        this.refRequestClass = Objects.requireNonNull(referenceRequestClass, "parameter referenceRequestClass cannot be null");
    }

    @Nonnull
    public T2 buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public T2 buildRequest(@Nullable List<? extends Option> requestOptions) {
        try {
            return (T2)((BaseReferenceRequest)this.refRequestClass.getConstructor(String.class, IBaseClient.class, List.class).newInstance(this.getRequestUrl(), this.getClient(), requestOptions));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new ClientException("Could not find the required class", ex);
        }
    }
}

