/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.restclient;

import com.google.common.hash.Hashing;
import com.microsoft.bot.restclient.RestClient;
import com.microsoft.bot.restclient.ServiceResponseBuilder;
import com.microsoft.bot.restclient.credentials.ServiceClientCredentials;
import com.microsoft.bot.restclient.protocol.SerializerAdapter;
import com.microsoft.bot.restclient.serializer.JacksonAdapter;
import java.net.NetworkInterface;
import java.util.Enumeration;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

public abstract class ServiceClient {
    private final RestClient restClient;
    private static final String MAC_ADDRESS_HASH;
    private static final String OS;
    private static final String JAVA_VERSION;

    protected ServiceClient(String baseUrl) {
        this(baseUrl, new OkHttpClient.Builder(), new Retrofit.Builder());
    }

    protected ServiceClient(String baseUrl, OkHttpClient.Builder clientBuilder, Retrofit.Builder restBuilder) {
        this(new RestClient.Builder(clientBuilder, restBuilder).withBaseUrl(baseUrl).withResponseBuilderFactory(new ServiceResponseBuilder.Factory()).withSerializerAdapter(new JacksonAdapter()).build());
    }

    protected ServiceClient(String baseUrl, ServiceClientCredentials credentials) {
        this(baseUrl, credentials, new OkHttpClient.Builder(), new Retrofit.Builder());
    }

    protected ServiceClient(String baseUrl, ServiceClientCredentials credentials, OkHttpClient.Builder clientBuilder, Retrofit.Builder restBuilder) {
        this(new RestClient.Builder(clientBuilder, restBuilder).withBaseUrl(baseUrl).withCredentials(credentials).withSerializerAdapter(new JacksonAdapter()).withResponseBuilderFactory(new ServiceResponseBuilder.Factory()).build());
    }

    protected ServiceClient(RestClient restClient) {
        this.restClient = restClient;
    }

    public RestClient restClient() {
        return this.restClient;
    }

    public Retrofit retrofit() {
        return this.restClient.retrofit();
    }

    public OkHttpClient httpClient() {
        return this.restClient.httpClient();
    }

    public SerializerAdapter<?> serializerAdapter() {
        return this.restClient.serializerAdapter();
    }

    public String userAgent() {
        return String.format("Azure-SDK-For-Java/%s OS:%s MacAddressHash:%s Java:%s", this.getClass().getPackage().getImplementationVersion(), OS, MAC_ADDRESS_HASH, JAVA_VERSION);
    }

    static {
        OS = System.getProperty("os.name") + "/" + System.getProperty("os.version");
        String macAddress = "Unknown";
        try {
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            while (networks.hasMoreElements()) {
                NetworkInterface network = networks.nextElement();
                byte[] mac = network.getHardwareAddress();
                if (mac == null) continue;
                macAddress = Hashing.sha256().hashBytes(mac).toString();
                break;
            }
        }
        catch (Throwable networks) {
            // empty catch block
        }
        MAC_ADDRESS_HASH = macAddress;
        String version = System.getProperty("java.version");
        JAVA_VERSION = version != null ? version : "Unknown";
    }
}

