/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.rest;

import com.google.common.reflect.TypeToken;
import com.microsoft.bot.connector.Async;
import com.microsoft.bot.connector.rest.ErrorResponseException;
import com.microsoft.bot.connector.rest.RestTeamsConnectorClient;
import com.microsoft.bot.connector.teams.TeamsOperations;
import com.microsoft.bot.restclient.ServiceResponse;
import com.microsoft.bot.schema.teams.ConversationList;
import com.microsoft.bot.schema.teams.TeamDetails;
import com.microsoft.bot.schema.teams.TeamsMeetingParticipant;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public class RestTeamsOperations
implements TeamsOperations {
    private TeamsService service;
    private RestTeamsConnectorClient client;

    RestTeamsOperations(Retrofit withRetrofit, RestTeamsConnectorClient withClient) {
        this.service = (TeamsService)withRetrofit.create(TeamsService.class);
        this.client = withClient;
    }

    @Override
    public CompletableFuture<ConversationList> fetchChannelList(String teamId) {
        if (teamId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter teamId is required and cannot be null."));
        }
        return this.service.fetchChannelList(teamId, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
            try {
                return this.fetchChannelListDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("fetchChannelList", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<ConversationList> fetchChannelListDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ConversationList>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<TeamDetails> fetchTeamDetails(String teamId) {
        if (teamId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter teamId is required and cannot be null."));
        }
        return this.service.fetchTeamDetails(teamId, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
            try {
                return this.fetchTeamDetailsDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("fetchTeamDetails", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<TeamDetails> fetchTeamDetailsDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TeamDetails>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<TeamsMeetingParticipant> fetchParticipant(String meetingId, String participantId, String tenantId) {
        return this.service.fetchParticipant(meetingId, participantId, tenantId, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
            try {
                return this.fetchParticipantDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("fetchParticipant", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<TeamsMeetingParticipant> fetchParticipantDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TeamsMeetingParticipant>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface TeamsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Teams fetchChannelList"})
        @GET(value="v3/teams/{teamId}/conversations")
        public CompletableFuture<Response<ResponseBody>> fetchChannelList(@Path(value="teamId") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Teams fetchTeamDetails"})
        @POST(value="v3/teams/{teamId}")
        public CompletableFuture<Response<ResponseBody>> fetchTeamDetails(@Path(value="teamId") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Teams fetchParticipant"})
        @GET(value="v1/meetings/{meetingId}/participants/{participantId}")
        public CompletableFuture<Response<ResponseBody>> fetchParticipant(@Path(value="meetingId") String var1, @Path(value="participantId") String var2, @Query(value="tenantId") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);
    }
}

