/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.rest;

import com.microsoft.bot.connector.UserAgent;
import com.microsoft.bot.connector.rest.RestTeamsOperations;
import com.microsoft.bot.connector.teams.TeamsConnectorClient;
import com.microsoft.bot.connector.teams.TeamsOperations;
import com.microsoft.bot.restclient.RestClient;
import com.microsoft.bot.restclient.ServiceClient;
import com.microsoft.bot.restclient.ServiceResponseBuilder;
import com.microsoft.bot.restclient.credentials.ServiceClientCredentials;
import com.microsoft.bot.restclient.retry.RetryStrategy;
import com.microsoft.bot.restclient.serializer.JacksonAdapter;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

public class RestTeamsConnectorClient
extends ServiceClient
implements TeamsConnectorClient {
    private static final int RETRY_TIMEOUT = 30;
    private String acceptLanguage;
    private String userAgentString;
    private RetryStrategy retryStrategy = null;
    private TeamsOperations teamsOperations = null;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;

    public RestTeamsConnectorClient(ServiceClientCredentials credentials) {
        this("https://api.botframework.com", credentials);
    }

    public RestTeamsConnectorClient(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    protected RestTeamsConnectorClient(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.teamsOperations = new RestTeamsOperations(this.restClient().retrofit(), this);
        this.userAgentString = UserAgent.value();
    }

    @Override
    public RestClient getRestClient() {
        return super.restClient();
    }

    @Override
    public String baseUrl() {
        return this.getRestClient().retrofit().baseUrl().toString();
    }

    @Override
    public ServiceClientCredentials credentials() {
        return this.getRestClient().credentials();
    }

    @Override
    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    @Override
    public void setAcceptLanguage(String withAcceptLanguage) {
        this.acceptLanguage = withAcceptLanguage;
    }

    @Override
    public String getUserAgent() {
        return this.userAgentString;
    }

    @Override
    public String userAgent() {
        return this.getUserAgent();
    }

    public void setRestRetryStrategy(RetryStrategy strategy) {
        this.retryStrategy = strategy;
    }

    public RetryStrategy getRestRetryStrategy() {
        return this.retryStrategy;
    }

    @Override
    public int getLongRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    @Override
    public void setLongRunningOperationRetryTimeout(int timeout) {
        this.longRunningOperationRetryTimeout = timeout;
    }

    @Override
    public boolean getGenerateClientRequestId() {
        return this.generateClientRequestId;
    }

    @Override
    public void setGenerateClientRequestId(boolean requestId) {
        this.generateClientRequestId = requestId;
    }

    @Override
    public TeamsOperations getTeams() {
        return this.teamsOperations;
    }

    public static RestClient.Builder getDefaultRestClientBuilder(String baseUrl, ServiceClientCredentials credentials) {
        return new RestClient.Builder(new OkHttpClient.Builder(), new Retrofit.Builder()).withBaseUrl(baseUrl).withCredentials(credentials).withSerializerAdapter(new JacksonAdapter()).withResponseBuilderFactory(new ServiceResponseBuilder.Factory());
    }

    @Override
    public void close() throws Exception {
    }
}

